/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.enforcer.rule;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.FileUtils;

public class NewObjectMapperDefinitionDeniedRule
implements EnforcerRule {
    private String excludeClasses;
    private static final String REGEX_TO_FIND_NEW_OBJECT_MAPPER_DEFINITION = ".*new\\s+(ObjectMapper|com\\s?[.]\\s?fasterxml\\s?[.]\\s?jackson\\s?[.]\\s?databind\\s?[.]\\s?ObjectMapper).*";

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        Object[] ignoreClasses = (this.excludeClasses != null ? this.excludeClasses : "").split(",");
        log.info((CharSequence)("Classes that can create new ObjectMapper objects: " + Arrays.toString(ignoreClasses)));
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            File baseDir = project.getBasedir();
            if (baseDir.exists() && baseDir.isDirectory()) {
                List javaFiles = FileUtils.getFiles((File)baseDir, (String)"**/*.java", (String)"target/");
                log.info((CharSequence)("Reading all Java files in base directory " + baseDir));
                for (File javaFile : javaFiles) {
                    String readLinesFromFile;
                    boolean newObjectMapperDefined;
                    if (!Arrays.stream(ignoreClasses).noneMatch(javaFile.getName()::endsWith) || !(newObjectMapperDefined = (readLinesFromFile = FileUtils.fileRead((File)javaFile).trim().replaceAll("\\s+", " ")).matches(REGEX_TO_FIND_NEW_OBJECT_MAPPER_DEFINITION))) continue;
                    throw new EnforcerRuleException("New ObjectMapper defined in " + javaFile.getAbsolutePath() + ". Please re-use the ObjectMapper defined in Serialization.java by calling com.oracle.bmc.http.Serialization.getObjectMapper().");
                }
            }
        }
        catch (ExpressionEvaluationException ex) {
            throw new EnforcerRuleException("Unable to lookup an expression " + ex.getLocalizedMessage(), (Exception)((Object)ex));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCacheId() {
        return this.getClass().getSimpleName() + "-notCacheable";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

