/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.oracle.bmc.encryption.OciCryptoInputStream;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class EncryptionStream
extends OciCryptoInputStream {
    private final CipherInputStream cipherInputStream;
    private final InputStream inputStream;
    private final ByteArrayInputStream headerBuffer;

    public EncryptionStream(InputStream inputStream, Cipher cipher, EncryptionHeader header) {
        super(header);
        this.cipherInputStream = new CipherInputStream(inputStream, cipher);
        this.inputStream = inputStream;
        this.headerBuffer = new ByteArrayInputStream(header.getHeaderBytes());
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.headerBuffer.read(b);
        if (result == -1) {
            result = this.cipherInputStream.read(b);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.cipherInputStream != null) {
            this.cipherInputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

