/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emwarehouse.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetEmWarehouseRequest
extends BmcRequest<Void> {
    private String emWarehouseId;
    private String opcRequestId;

    public String getEmWarehouseId() {
        return this.emWarehouseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().emWarehouseId(this.emWarehouseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",emWarehouseId=").append(String.valueOf(this.emWarehouseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEmWarehouseRequest)) {
            return false;
        }
        GetEmWarehouseRequest other = (GetEmWarehouseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.emWarehouseId, other.emWarehouseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.emWarehouseId == null ? 43 : this.emWarehouseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEmWarehouseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String emWarehouseId = null;
        private String opcRequestId = null;

        public Builder emWarehouseId(String emWarehouseId) {
            this.emWarehouseId = emWarehouseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEmWarehouseRequest o) {
            this.emWarehouseId(o.getEmWarehouseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEmWarehouseRequest build() {
            GetEmWarehouseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEmWarehouseRequest buildWithoutInvocationCallback() {
            GetEmWarehouseRequest request = new GetEmWarehouseRequest();
            request.emWarehouseId = this.emWarehouseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

