/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.email.model.CreateDkimDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDkimRequest
extends BmcRequest<CreateDkimDetails> {
    private CreateDkimDetails createDkimDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateDkimDetails getCreateDkimDetails() {
        return this.createDkimDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateDkimDetails getBody$() {
        return this.createDkimDetails;
    }

    public Builder toBuilder() {
        return new Builder().createDkimDetails(this.createDkimDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createDkimDetails=").append(String.valueOf((Object)this.createDkimDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDkimRequest)) {
            return false;
        }
        CreateDkimRequest other = (CreateDkimRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createDkimDetails, (Object)other.createDkimDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createDkimDetails == null ? 43 : this.createDkimDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDkimRequest, CreateDkimDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateDkimDetails createDkimDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createDkimDetails(CreateDkimDetails createDkimDetails) {
            this.createDkimDetails = createDkimDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDkimRequest o) {
            this.createDkimDetails(o.getCreateDkimDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDkimRequest build() {
            CreateDkimRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDkimDetails body) {
            this.createDkimDetails(body);
            return this;
        }

        public CreateDkimRequest buildWithoutInvocationCallback() {
            CreateDkimRequest request = new CreateDkimRequest();
            request.createDkimDetails = this.createDkimDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

