/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTransferDeviceRequest
extends BmcRequest<Void> {
    private String id;
    private String transferDeviceLabel;

    public String getId() {
        return this.id;
    }

    public String getTransferDeviceLabel() {
        return this.transferDeviceLabel;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).transferDeviceLabel(this.transferDeviceLabel);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",transferDeviceLabel=").append(String.valueOf(this.transferDeviceLabel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTransferDeviceRequest)) {
            return false;
        }
        GetTransferDeviceRequest other = (GetTransferDeviceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.transferDeviceLabel, other.transferDeviceLabel);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.transferDeviceLabel == null ? 43 : this.transferDeviceLabel.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTransferDeviceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String transferDeviceLabel = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferDeviceLabel(String transferDeviceLabel) {
            this.transferDeviceLabel = transferDeviceLabel;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTransferDeviceRequest o) {
            this.id(o.getId());
            this.transferDeviceLabel(o.getTransferDeviceLabel());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTransferDeviceRequest build() {
            GetTransferDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTransferDeviceRequest buildWithoutInvocationCallback() {
            GetTransferDeviceRequest request = new GetTransferDeviceRequest();
            request.id = this.id;
            request.transferDeviceLabel = this.transferDeviceLabel;
            return request;
        }
    }
}

