/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.dts.TransferApplianceEntitlement;
import com.oracle.bmc.dts.model.TransferApplianceEntitlement;
import com.oracle.bmc.dts.requests.GetTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.responses.GetTransferApplianceEntitlementResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransferApplianceEntitlementWaiters {
    private final ExecutorService executorService;
    private final TransferApplianceEntitlement client;

    public TransferApplianceEntitlementWaiters(ExecutorService executorService, TransferApplianceEntitlement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> forTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request, TransferApplianceEntitlement.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTransferApplianceEntitlement(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> forTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request, TransferApplianceEntitlement.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTransferApplianceEntitlement(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> forTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TransferApplianceEntitlement.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTransferApplianceEntitlement(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse> forTransferApplianceEntitlement(BmcGenericWaiter waiter, GetTransferApplianceEntitlementRequest request, TransferApplianceEntitlement.LifecycleState ... targetStates) {
        final HashSet<TransferApplianceEntitlement.LifecycleState> targetStatesSet = new HashSet<TransferApplianceEntitlement.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTransferApplianceEntitlementRequest, GetTransferApplianceEntitlementResponse>(){

            @Override
            public GetTransferApplianceEntitlementResponse apply(GetTransferApplianceEntitlementRequest request) {
                return TransferApplianceEntitlementWaiters.this.client.getTransferApplianceEntitlement(request);
            }
        }, (Predicate)new Predicate<GetTransferApplianceEntitlementResponse>(){

            @Override
            public boolean test(GetTransferApplianceEntitlementResponse response) {
                return targetStatesSet.contains((Object)response.getTransferApplianceEntitlement().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TransferApplianceEntitlement.LifecycleState.Deleted)), (Object)request);
    }
}

