/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.TsigKey;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdateTsigKeyResponse
extends BmcResponse {
    private String eTag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private TsigKey tsigKey;

    public String getETag() {
        return this.eTag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public TsigKey getTsigKey() {
        return this.tsigKey;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "eTag", "opcRequestId", "opcWorkRequestId", "tsigKey"})
    private UpdateTsigKeyResponse(int __httpStatusCode__, Map<String, List<String>> headers, String eTag, String opcRequestId, String opcWorkRequestId, TsigKey tsigKey) {
        super(__httpStatusCode__, headers);
        this.eTag = eTag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.tsigKey = tsigKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",tsigKey=").append(String.valueOf((Object)this.tsigKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTsigKeyResponse)) {
            return false;
        }
        UpdateTsigKeyResponse other = (UpdateTsigKeyResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.eTag, other.eTag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals((Object)this.tsigKey, (Object)other.tsigKey);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.tsigKey == null ? 43 : this.tsigKey.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdateTsigKeyResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String eTag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private TsigKey tsigKey;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder tsigKey(TsigKey tsigKey) {
            this.tsigKey = tsigKey;
            return this;
        }

        public Builder copy(UpdateTsigKeyResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.eTag(o.getETag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.tsigKey(o.getTsigKey());
            return this;
        }

        public UpdateTsigKeyResponse build() {
            return new UpdateTsigKeyResponse(this.__httpStatusCode__, this.headers, this.eTag, this.opcRequestId, this.opcWorkRequestId, this.tsigKey);
        }
    }
}

