/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.Resolver;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetResolverResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private Resolver resolver;
    private boolean isNotModified;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "resolver", "isNotModified"})
    private GetResolverResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, Resolver resolver, boolean isNotModified) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.resolver = resolver;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",resolver=").append(String.valueOf((Object)this.resolver));
        sb.append(",isNotModified=").append(this.isNotModified);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResolverResponse)) {
            return false;
        }
        GetResolverResponse other = (GetResolverResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.resolver, (Object)other.resolver) && this.isNotModified == other.isNotModified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.resolver == null ? 43 : this.resolver.hashCode());
        result = result * 59 + (this.isNotModified ? 79 : 97);
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetResolverResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private Resolver resolver;
        private boolean isNotModified;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resolver(Resolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public Builder copy(GetResolverResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.resolver(o.getResolver());
            this.isNotModified(o.isNotModified());
            return this;
        }

        public GetResolverResponse build() {
            return new GetResolverResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.resolver, this.isNotModified);
        }
    }
}

