/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.DnsAsyncClient;
import com.oracle.bmc.dns.DnsPaginators;
import com.oracle.bmc.dns.DnsWaiters;
import com.oracle.bmc.dns.model.RRSet;
import com.oracle.bmc.dns.model.RecordCollection;
import com.oracle.bmc.dns.model.Resolver;
import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.dns.model.ResolverEndpointSummary;
import com.oracle.bmc.dns.model.ResolverSummary;
import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.dns.model.SteeringPolicyAttachment;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.dns.model.SteeringPolicySummary;
import com.oracle.bmc.dns.model.TsigKey;
import com.oracle.bmc.dns.model.TsigKeySummary;
import com.oracle.bmc.dns.model.View;
import com.oracle.bmc.dns.model.ViewSummary;
import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.dns.model.ZoneSummary;
import com.oracle.bmc.dns.model.ZoneTransferServer;
import com.oracle.bmc.dns.requests.ChangeResolverCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeTsigKeyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeViewCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateTsigKeyRequest;
import com.oracle.bmc.dns.requests.CreateViewRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteDomainRecordsRequest;
import com.oracle.bmc.dns.requests.DeleteRRSetRequest;
import com.oracle.bmc.dns.requests.DeleteResolverEndpointRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteTsigKeyRequest;
import com.oracle.bmc.dns.requests.DeleteViewRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetResolverEndpointRequest;
import com.oracle.bmc.dns.requests.GetResolverRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.requests.GetZoneContentRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.ListResolverEndpointsRequest;
import com.oracle.bmc.dns.requests.ListResolversRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListTsigKeysRequest;
import com.oracle.bmc.dns.requests.ListViewsRequest;
import com.oracle.bmc.dns.requests.ListZoneTransferServersRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.requests.PatchDomainRecordsRequest;
import com.oracle.bmc.dns.requests.PatchRRSetRequest;
import com.oracle.bmc.dns.requests.PatchZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateDomainRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.requests.UpdateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.UpdateResolverRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.requests.UpdateViewRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeResolverCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeTsigKeyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeViewCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateTsigKeyResponse;
import com.oracle.bmc.dns.responses.CreateViewResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteDomainRecordsResponse;
import com.oracle.bmc.dns.responses.DeleteRRSetResponse;
import com.oracle.bmc.dns.responses.DeleteResolverEndpointResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteTsigKeyResponse;
import com.oracle.bmc.dns.responses.DeleteViewResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetResolverEndpointResponse;
import com.oracle.bmc.dns.responses.GetResolverResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.dns.responses.GetZoneContentResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.ListResolverEndpointsResponse;
import com.oracle.bmc.dns.responses.ListResolversResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListTsigKeysResponse;
import com.oracle.bmc.dns.responses.ListViewsResponse;
import com.oracle.bmc.dns.responses.ListZoneTransferServersResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.dns.responses.PatchDomainRecordsResponse;
import com.oracle.bmc.dns.responses.PatchRRSetResponse;
import com.oracle.bmc.dns.responses.PatchZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateDomainRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.UpdateResolverResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.dns.responses.UpdateViewResponse;
import com.oracle.bmc.dns.responses.UpdateZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsClient
extends BaseSyncClient
implements Dns {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DNS").serviceEndpointPrefix("dns").serviceEndpointTemplate("https://dns.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DnsAsyncClient.class);
    private final DnsWaiters waiters;
    private final DnsPaginators paginators;

    private DnsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Dns-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DnsWaiters(executorService, this);
        this.paginators = new DnsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeResolverCompartmentResponse changeResolverCompartment(ChangeResolverCompartmentRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeResolverCompartmentDetails(), "changeResolverCompartmentDetails is required");
        return (ChangeResolverCompartmentResponse)this.clientCall(request, ChangeResolverCompartmentResponse::builder).logger(LOG, "changeResolverCompartment").serviceDetails("Dns", "ChangeResolverCompartment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Resolver/ChangeResolverCompartment").method(Method.POST).requestBuilder(ChangeResolverCompartmentRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("actions").appendPathParam("changeCompartment").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeResolverCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeResolverCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeSteeringPolicyCompartmentResponse changeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyId(), (String)"steeringPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSteeringPolicyCompartmentDetails(), "changeSteeringPolicyCompartmentDetails is required");
        return (ChangeSteeringPolicyCompartmentResponse)this.clientCall(request, ChangeSteeringPolicyCompartmentResponse::builder).logger(LOG, "changeSteeringPolicyCompartment").serviceDetails("Dns", "ChangeSteeringPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicy/ChangeSteeringPolicyCompartment").method(Method.POST).requestBuilder(ChangeSteeringPolicyCompartmentRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendPathParam(request.getSteeringPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSteeringPolicyCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeTsigKeyCompartmentResponse changeTsigKeyCompartment(ChangeTsigKeyCompartmentRequest request) {
        Validate.notBlank((String)request.getTsigKeyId(), (String)"tsigKeyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTsigKeyCompartmentDetails(), "changeTsigKeyCompartmentDetails is required");
        return (ChangeTsigKeyCompartmentResponse)this.clientCall(request, ChangeTsigKeyCompartmentResponse::builder).logger(LOG, "changeTsigKeyCompartment").serviceDetails("Dns", "ChangeTsigKeyCompartment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/TsigKey/ChangeTsigKeyCompartment").method(Method.POST).requestBuilder(ChangeTsigKeyCompartmentRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendPathParam(request.getTsigKeyId()).appendPathParam("actions").appendPathParam("changeCompartment").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTsigKeyCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeViewCompartmentResponse changeViewCompartment(ChangeViewCompartmentRequest request) {
        Validate.notBlank((String)request.getViewId(), (String)"viewId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeViewCompartmentDetails(), "changeViewCompartmentDetails is required");
        return (ChangeViewCompartmentResponse)this.clientCall(request, ChangeViewCompartmentResponse::builder).logger(LOG, "changeViewCompartment").serviceDetails("Dns", "ChangeViewCompartment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/View/ChangeViewCompartment").method(Method.POST).requestBuilder(ChangeViewCompartmentRequest::builder).basePath("/20180115").appendPathParam("views").appendPathParam(request.getViewId()).appendPathParam("actions").appendPathParam("changeCompartment").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeViewCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeViewCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeZoneCompartmentResponse changeZoneCompartment(ChangeZoneCompartmentRequest request) {
        Validate.notBlank((String)request.getZoneId(), (String)"zoneId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeZoneCompartmentDetails(), "changeZoneCompartmentDetails is required");
        return (ChangeZoneCompartmentResponse)this.clientCall(request, ChangeZoneCompartmentResponse::builder).logger(LOG, "changeZoneCompartment").serviceDetails("Dns", "ChangeZoneCompartment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Zone/ChangeZoneCompartment").method(Method.POST).requestBuilder(ChangeZoneCompartmentRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneId()).appendPathParam("actions").appendPathParam("changeCompartment").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeZoneCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeZoneCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateResolverEndpointResponse createResolverEndpoint(CreateResolverEndpointRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateResolverEndpointDetails(), "createResolverEndpointDetails is required");
        return (CreateResolverEndpointResponse)this.clientCall(request, CreateResolverEndpointResponse::builder).logger(LOG, "createResolverEndpoint").serviceDetails("Dns", "CreateResolverEndpoint", "").method(Method.POST).requestBuilder(CreateResolverEndpointRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("endpoints").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResolverEndpoint.class, CreateResolverEndpointResponse.Builder::resolverEndpoint).handleResponseHeaderString("etag", CreateResolverEndpointResponse.Builder::etag).handleResponseHeaderString("Location", CreateResolverEndpointResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateResolverEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateResolverEndpointResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateSteeringPolicyResponse createSteeringPolicy(CreateSteeringPolicyRequest request) {
        Objects.requireNonNull(request.getCreateSteeringPolicyDetails(), "createSteeringPolicyDetails is required");
        return (CreateSteeringPolicyResponse)this.clientCall(request, CreateSteeringPolicyResponse::builder).logger(LOG, "createSteeringPolicy").serviceDetails("Dns", "CreateSteeringPolicy", "").method(Method.POST).requestBuilder(CreateSteeringPolicyRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SteeringPolicy.class, CreateSteeringPolicyResponse.Builder::steeringPolicy).handleResponseHeaderString("ETag", CreateSteeringPolicyResponse.Builder::eTag).handleResponseHeaderString("Location", CreateSteeringPolicyResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateSteeringPolicyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateSteeringPolicyAttachmentResponse createSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request) {
        Objects.requireNonNull(request.getCreateSteeringPolicyAttachmentDetails(), "createSteeringPolicyAttachmentDetails is required");
        return (CreateSteeringPolicyAttachmentResponse)this.clientCall(request, CreateSteeringPolicyAttachmentResponse::builder).logger(LOG, "createSteeringPolicyAttachment").serviceDetails("Dns", "CreateSteeringPolicyAttachment", "").method(Method.POST).requestBuilder(CreateSteeringPolicyAttachmentRequest::builder).basePath("/20180115").appendPathParam("steeringPolicyAttachments").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SteeringPolicyAttachment.class, CreateSteeringPolicyAttachmentResponse.Builder::steeringPolicyAttachment).handleResponseHeaderString("ETag", CreateSteeringPolicyAttachmentResponse.Builder::eTag).handleResponseHeaderString("Location", CreateSteeringPolicyAttachmentResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateSteeringPolicyAttachmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateTsigKeyResponse createTsigKey(CreateTsigKeyRequest request) {
        Objects.requireNonNull(request.getCreateTsigKeyDetails(), "createTsigKeyDetails is required");
        return (CreateTsigKeyResponse)this.clientCall(request, CreateTsigKeyResponse::builder).logger(LOG, "createTsigKey").serviceDetails("Dns", "CreateTsigKey", "").method(Method.POST).requestBuilder(CreateTsigKeyRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TsigKey.class, CreateTsigKeyResponse.Builder::tsigKey).handleResponseHeaderString("ETag", CreateTsigKeyResponse.Builder::eTag).handleResponseHeaderString("Location", CreateTsigKeyResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateTsigKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateTsigKeyResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateViewResponse createView(CreateViewRequest request) {
        Objects.requireNonNull(request.getCreateViewDetails(), "createViewDetails is required");
        return (CreateViewResponse)this.clientCall(request, CreateViewResponse::builder).logger(LOG, "createView").serviceDetails("Dns", "CreateView", "").method(Method.POST).requestBuilder(CreateViewRequest::builder).basePath("/20180115").appendPathParam("views").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(View.class, CreateViewResponse.Builder::view).handleResponseHeaderString("etag", CreateViewResponse.Builder::etag).handleResponseHeaderString("Location", CreateViewResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateViewResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateViewResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateZoneResponse createZone(CreateZoneRequest request) {
        Objects.requireNonNull(request.getCreateZoneDetails(), "createZoneDetails is required");
        return (CreateZoneResponse)this.clientCall(request, CreateZoneResponse::builder).logger(LOG, "createZone").serviceDetails("Dns", "CreateZone", "").method(Method.POST).requestBuilder(CreateZoneRequest::builder).basePath("/20180115").appendPathParam("zones").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Zone.class, CreateZoneResponse.Builder::zone).handleResponseHeaderString("ETag", CreateZoneResponse.Builder::eTag).handleResponseHeaderString("Location", CreateZoneResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateZoneResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateZoneResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteDomainRecordsResponse deleteDomainRecords(DeleteDomainRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        return (DeleteDomainRecordsResponse)this.clientCall(request, DeleteDomainRecordsResponse::builder).logger(LOG, "deleteDomainRecords").serviceDetails("Dns", "DeleteDomainRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/DeleteDomainRecords").method(Method.DELETE).requestBuilder(DeleteDomainRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDomainRecordsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteRRSetResponse deleteRRSet(DeleteRRSetRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        return (DeleteRRSetResponse)this.clientCall(request, DeleteRRSetResponse::builder).logger(LOG, "deleteRRSet").serviceDetails("Dns", "DeleteRRSet", "").method(Method.DELETE).requestBuilder(DeleteRRSetRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendPathParam(request.getRtype()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRRSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteResolverEndpointResponse deleteResolverEndpoint(DeleteResolverEndpointRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResolverEndpointName(), (String)"resolverEndpointName must not be blank", (Object[])new Object[0]);
        return (DeleteResolverEndpointResponse)this.clientCall(request, DeleteResolverEndpointResponse::builder).logger(LOG, "deleteResolverEndpoint").serviceDetails("Dns", "DeleteResolverEndpoint", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/ResolverEndpoint/DeleteResolverEndpoint").method(Method.DELETE).requestBuilder(DeleteResolverEndpointRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("endpoints").appendPathParam(request.getResolverEndpointName()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteResolverEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteResolverEndpointResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteSteeringPolicyResponse deleteSteeringPolicy(DeleteSteeringPolicyRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyId(), (String)"steeringPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteSteeringPolicyResponse)this.clientCall(request, DeleteSteeringPolicyResponse::builder).logger(LOG, "deleteSteeringPolicy").serviceDetails("Dns", "DeleteSteeringPolicy", "").method(Method.DELETE).requestBuilder(DeleteSteeringPolicyRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendPathParam(request.getSteeringPolicyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSteeringPolicyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteSteeringPolicyAttachmentResponse deleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyAttachmentId(), (String)"steeringPolicyAttachmentId must not be blank", (Object[])new Object[0]);
        return (DeleteSteeringPolicyAttachmentResponse)this.clientCall(request, DeleteSteeringPolicyAttachmentResponse::builder).logger(LOG, "deleteSteeringPolicyAttachment").serviceDetails("Dns", "DeleteSteeringPolicyAttachment", "").method(Method.DELETE).requestBuilder(DeleteSteeringPolicyAttachmentRequest::builder).basePath("/20180115").appendPathParam("steeringPolicyAttachments").appendPathParam(request.getSteeringPolicyAttachmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSteeringPolicyAttachmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteTsigKeyResponse deleteTsigKey(DeleteTsigKeyRequest request) {
        Validate.notBlank((String)request.getTsigKeyId(), (String)"tsigKeyId must not be blank", (Object[])new Object[0]);
        return (DeleteTsigKeyResponse)this.clientCall(request, DeleteTsigKeyResponse::builder).logger(LOG, "deleteTsigKey").serviceDetails("Dns", "DeleteTsigKey", "").method(Method.DELETE).requestBuilder(DeleteTsigKeyRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendPathParam(request.getTsigKeyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTsigKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteTsigKeyResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteViewResponse deleteView(DeleteViewRequest request) {
        Validate.notBlank((String)request.getViewId(), (String)"viewId must not be blank", (Object[])new Object[0]);
        return (DeleteViewResponse)this.clientCall(request, DeleteViewResponse::builder).logger(LOG, "deleteView").serviceDetails("Dns", "DeleteView", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/View/DeleteView").method(Method.DELETE).requestBuilder(DeleteViewRequest::builder).basePath("/20180115").appendPathParam("views").appendPathParam(request.getViewId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteViewResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteViewResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteZoneResponse deleteZone(DeleteZoneRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        return (DeleteZoneResponse)this.clientCall(request, DeleteZoneResponse::builder).logger(LOG, "deleteZone").serviceDetails("Dns", "DeleteZone", "").method(Method.DELETE).requestBuilder(DeleteZoneRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteZoneResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteZoneResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetDomainRecordsResponse getDomainRecords(GetDomainRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        return (GetDomainRecordsResponse)this.clientCall(request, GetDomainRecordsResponse::builder).logger(LOG, "getDomainRecords").serviceDetails("Dns", "GetDomainRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/GetDomainRecords").method(Method.GET).requestBuilder(GetDomainRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("zoneVersion", (Object)request.getZoneVersion()).appendQueryParam("rtype", (Object)request.getRtype()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordCollection.class, GetDomainRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", GetDomainRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", GetDomainRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", GetDomainRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetDomainRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRRSetResponse getRRSet(GetRRSetRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        return (GetRRSetResponse)this.clientCall(request, GetRRSetResponse::builder).logger(LOG, "getRRSet").serviceDetails("Dns", "GetRRSet", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/RRSet/GetRRSet").method(Method.GET).requestBuilder(GetRRSetRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendPathParam(request.getRtype()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("zoneVersion", (Object)request.getZoneVersion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RRSet.class, GetRRSetResponse.Builder::rRSet).handleResponseHeaderString("opc-next-page", GetRRSetResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", GetRRSetResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", GetRRSetResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetRRSetResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetResolverResponse getResolver(GetResolverRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        return (GetResolverResponse)this.clientCall(request, GetResolverResponse::builder).logger(LOG, "getResolver").serviceDetails("Dns", "GetResolver", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Resolver/GetResolver").method(Method.GET).requestBuilder(GetResolverRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Resolver.class, GetResolverResponse.Builder::resolver).handleResponseHeaderString("etag", GetResolverResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResolverResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetResolverEndpointResponse getResolverEndpoint(GetResolverEndpointRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResolverEndpointName(), (String)"resolverEndpointName must not be blank", (Object[])new Object[0]);
        return (GetResolverEndpointResponse)this.clientCall(request, GetResolverEndpointResponse::builder).logger(LOG, "getResolverEndpoint").serviceDetails("Dns", "GetResolverEndpoint", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/ResolverEndpoint/GetResolverEndpoint").method(Method.GET).requestBuilder(GetResolverEndpointRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("endpoints").appendPathParam(request.getResolverEndpointName()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResolverEndpoint.class, GetResolverEndpointResponse.Builder::resolverEndpoint).handleResponseHeaderString("etag", GetResolverEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResolverEndpointResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSteeringPolicyResponse getSteeringPolicy(GetSteeringPolicyRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyId(), (String)"steeringPolicyId must not be blank", (Object[])new Object[0]);
        return (GetSteeringPolicyResponse)this.clientCall(request, GetSteeringPolicyResponse::builder).logger(LOG, "getSteeringPolicy").serviceDetails("Dns", "GetSteeringPolicy", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicy/GetSteeringPolicy").method(Method.GET).requestBuilder(GetSteeringPolicyRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendPathParam(request.getSteeringPolicyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SteeringPolicy.class, GetSteeringPolicyResponse.Builder::steeringPolicy).handleResponseHeaderString("opc-request-id", GetSteeringPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetSteeringPolicyResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSteeringPolicyAttachmentResponse getSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyAttachmentId(), (String)"steeringPolicyAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetSteeringPolicyAttachmentResponse)this.clientCall(request, GetSteeringPolicyAttachmentResponse::builder).logger(LOG, "getSteeringPolicyAttachment").serviceDetails("Dns", "GetSteeringPolicyAttachment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicyAttachment/GetSteeringPolicyAttachment").method(Method.GET).requestBuilder(GetSteeringPolicyAttachmentRequest::builder).basePath("/20180115").appendPathParam("steeringPolicyAttachments").appendPathParam(request.getSteeringPolicyAttachmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SteeringPolicyAttachment.class, GetSteeringPolicyAttachmentResponse.Builder::steeringPolicyAttachment).handleResponseHeaderString("opc-request-id", GetSteeringPolicyAttachmentResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetSteeringPolicyAttachmentResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTsigKeyResponse getTsigKey(GetTsigKeyRequest request) {
        Validate.notBlank((String)request.getTsigKeyId(), (String)"tsigKeyId must not be blank", (Object[])new Object[0]);
        return (GetTsigKeyResponse)this.clientCall(request, GetTsigKeyResponse::builder).logger(LOG, "getTsigKey").serviceDetails("Dns", "GetTsigKey", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/TsigKey/GetTsigKey").method(Method.GET).requestBuilder(GetTsigKeyRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendPathParam(request.getTsigKeyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TsigKey.class, GetTsigKeyResponse.Builder::tsigKey).handleResponseHeaderString("ETag", GetTsigKeyResponse.Builder::eTag).handleResponseHeaderString("opc-request-id", GetTsigKeyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetViewResponse getView(GetViewRequest request) {
        Validate.notBlank((String)request.getViewId(), (String)"viewId must not be blank", (Object[])new Object[0]);
        return (GetViewResponse)this.clientCall(request, GetViewResponse::builder).logger(LOG, "getView").serviceDetails("Dns", "GetView", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/View/GetView").method(Method.GET).requestBuilder(GetViewRequest::builder).basePath("/20180115").appendPathParam("views").appendPathParam(request.getViewId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(View.class, GetViewResponse.Builder::view).handleResponseHeaderString("etag", GetViewResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetViewResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetZoneResponse getZone(GetZoneRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        return (GetZoneResponse)this.clientCall(request, GetZoneResponse::builder).logger(LOG, "getZone").serviceDetails("Dns", "GetZone", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Zone/GetZone").method(Method.GET).requestBuilder(GetZoneRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Zone.class, GetZoneResponse.Builder::zone).handleResponseHeaderString("opc-request-id", GetZoneResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetZoneResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetZoneContentResponse getZoneContent(GetZoneContentRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        return (GetZoneContentResponse)this.clientCall(request, GetZoneContentResponse::builder).logger(LOG, "getZoneContent").serviceDetails("Dns", "GetZoneContent", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Zone/GetZoneContent").method(Method.GET).requestBuilder(GetZoneContentRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("content").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).accept(new String[]{"text/dns"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetZoneContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetZoneContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetZoneContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetZoneRecordsResponse getZoneRecords(GetZoneRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        return (GetZoneRecordsResponse)this.clientCall(request, GetZoneRecordsResponse::builder).logger(LOG, "getZoneRecords").serviceDetails("Dns", "GetZoneRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/GetZoneRecords").method(Method.GET).requestBuilder(GetZoneRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("zoneVersion", (Object)request.getZoneVersion()).appendQueryParam("domain", (Object)request.getDomain()).appendQueryParam("domainContains", (Object)request.getDomainContains()).appendQueryParam("rtype", (Object)request.getRtype()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).accept(new String[]{"application/json"}).appendHeader("If-None-Match", request.getIfNoneMatch()).appendHeader("If-Modified-Since", request.getIfModifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordCollection.class, GetZoneRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", GetZoneRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", GetZoneRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", GetZoneRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetZoneRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListResolverEndpointsResponse listResolverEndpoints(ListResolverEndpointsRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        return (ListResolverEndpointsResponse)this.clientCall(request, ListResolverEndpointsResponse::builder).logger(LOG, "listResolverEndpoints").serviceDetails("Dns", "ListResolverEndpoints", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/ResolverEndpoint/ListResolverEndpoints").method(Method.GET).requestBuilder(ListResolverEndpointsRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("endpoints").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ResolverEndpointSummary.class, ListResolverEndpointsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListResolverEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResolverEndpointsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListResolversResponse listResolvers(ListResolversRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResolversResponse)this.clientCall(request, ListResolversResponse::builder).logger(LOG, "listResolvers").serviceDetails("Dns", "ListResolvers", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Resolver/ListResolvers").method(Method.GET).requestBuilder(ListResolversRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ResolverSummary.class, ListResolversResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListResolversResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResolversResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSteeringPoliciesResponse listSteeringPolicies(ListSteeringPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSteeringPoliciesResponse)this.clientCall(request, ListSteeringPoliciesResponse::builder).logger(LOG, "listSteeringPolicies").serviceDetails("Dns", "ListSteeringPolicies", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicy/ListSteeringPolicies").method(Method.GET).requestBuilder(ListSteeringPoliciesRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("healthCheckMonitorId", (Object)request.getHealthCheckMonitorId()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("template", (Object)request.getTemplate()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SteeringPolicySummary.class, ListSteeringPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSteeringPoliciesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSteeringPoliciesResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", ListSteeringPoliciesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSteeringPolicyAttachmentsResponse listSteeringPolicyAttachments(ListSteeringPolicyAttachmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSteeringPolicyAttachmentsResponse)this.clientCall(request, ListSteeringPolicyAttachmentsResponse::builder).logger(LOG, "listSteeringPolicyAttachments").serviceDetails("Dns", "ListSteeringPolicyAttachments", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicyAttachment/ListSteeringPolicyAttachments").method(Method.GET).requestBuilder(ListSteeringPolicyAttachmentsRequest::builder).basePath("/20180115").appendPathParam("steeringPolicyAttachments").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("steeringPolicyId", (Object)request.getSteeringPolicyId()).appendQueryParam("zoneId", (Object)request.getZoneId()).appendQueryParam("domain", (Object)request.getDomain()).appendQueryParam("domainContains", (Object)request.getDomainContains()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SteeringPolicyAttachmentSummary.class, ListSteeringPolicyAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSteeringPolicyAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSteeringPolicyAttachmentsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", ListSteeringPolicyAttachmentsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTsigKeysResponse listTsigKeys(ListTsigKeysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTsigKeysResponse)this.clientCall(request, ListTsigKeysResponse::builder).logger(LOG, "listTsigKeys").serviceDetails("Dns", "ListTsigKeys", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/TsigKey/ListTsigKeys").method(Method.GET).requestBuilder(ListTsigKeysRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TsigKeySummary.class, ListTsigKeysResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListTsigKeysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListTsigKeysResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListViewsResponse listViews(ListViewsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListViewsResponse)this.clientCall(request, ListViewsResponse::builder).logger(LOG, "listViews").serviceDetails("Dns", "ListViews", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/View/ListViews").method(Method.GET).requestBuilder(ListViewsRequest::builder).basePath("/20180115").appendPathParam("views").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ViewSummary.class, ListViewsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListViewsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListViewsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListZoneTransferServersResponse listZoneTransferServers(ListZoneTransferServersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListZoneTransferServersResponse)this.clientCall(request, ListZoneTransferServersResponse::builder).logger(LOG, "listZoneTransferServers").serviceDetails("Dns", "ListZoneTransferServers", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/ZoneTransferServer/ListZoneTransferServers").method(Method.GET).requestBuilder(ListZoneTransferServersRequest::builder).basePath("/20180115").appendPathParam("zoneTransferServers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ZoneTransferServer.class, ListZoneTransferServersResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListZoneTransferServersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListZoneTransferServersResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListZonesResponse listZones(ListZonesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListZonesResponse)this.clientCall(request, ListZonesResponse::builder).logger(LOG, "listZones").serviceDetails("Dns", "ListZones", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Zone/ListZones").method(Method.GET).requestBuilder(ListZonesRequest::builder).basePath("/20180115").appendPathParam("zones").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("zoneType", (BmcEnum)request.getZoneType()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("tsigKeyId", (Object)request.getTsigKeyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ZoneSummary.class, ListZonesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListZonesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListZonesResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", ListZonesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PatchDomainRecordsResponse patchDomainRecords(PatchDomainRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchDomainRecordsDetails(), "patchDomainRecordsDetails is required");
        return (PatchDomainRecordsResponse)this.clientCall(request, PatchDomainRecordsResponse::builder).logger(LOG, "patchDomainRecords").serviceDetails("Dns", "PatchDomainRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/PatchDomainRecords").method(Method.PATCH).requestBuilder(PatchDomainRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, PatchDomainRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", PatchDomainRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", PatchDomainRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", PatchDomainRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", PatchDomainRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PatchRRSetResponse patchRRSet(PatchRRSetRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchRRSetDetails(), "patchRRSetDetails is required");
        return (PatchRRSetResponse)this.clientCall(request, PatchRRSetResponse::builder).logger(LOG, "patchRRSet").serviceDetails("Dns", "PatchRRSet", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/RRSet/PatchRRSet").method(Method.PATCH).requestBuilder(PatchRRSetRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendPathParam(request.getRtype()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, PatchRRSetResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", PatchRRSetResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", PatchRRSetResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", PatchRRSetResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", PatchRRSetResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PatchZoneRecordsResponse patchZoneRecords(PatchZoneRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchZoneRecordsDetails(), "patchZoneRecordsDetails is required");
        return (PatchZoneRecordsResponse)this.clientCall(request, PatchZoneRecordsResponse::builder).logger(LOG, "patchZoneRecords").serviceDetails("Dns", "PatchZoneRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/PatchZoneRecords").method(Method.PATCH).requestBuilder(PatchZoneRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, PatchZoneRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", PatchZoneRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", PatchZoneRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", PatchZoneRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", PatchZoneRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateDomainRecordsResponse updateDomainRecords(UpdateDomainRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDomainRecordsDetails(), "updateDomainRecordsDetails is required");
        return (UpdateDomainRecordsResponse)this.clientCall(request, UpdateDomainRecordsResponse::builder).logger(LOG, "updateDomainRecords").serviceDetails("Dns", "UpdateDomainRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/UpdateDomainRecords").method(Method.PUT).requestBuilder(UpdateDomainRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, UpdateDomainRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", UpdateDomainRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", UpdateDomainRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", UpdateDomainRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateDomainRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRRSetResponse updateRRSet(UpdateRRSetRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRRSetDetails(), "updateRRSetDetails is required");
        return (UpdateRRSetResponse)this.clientCall(request, UpdateRRSetResponse::builder).logger(LOG, "updateRRSet").serviceDetails("Dns", "UpdateRRSet", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/RRSet/UpdateRRSet").method(Method.PUT).requestBuilder(UpdateRRSetRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendPathParam(request.getDomain()).appendPathParam(request.getRtype()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, UpdateRRSetResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", UpdateRRSetResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", UpdateRRSetResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", UpdateRRSetResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateRRSetResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResolverDetails(), "updateResolverDetails is required");
        return (UpdateResolverResponse)this.clientCall(request, UpdateResolverResponse::builder).logger(LOG, "updateResolver").serviceDetails("Dns", "UpdateResolver", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Resolver/UpdateResolver").method(Method.PUT).requestBuilder(UpdateResolverRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Resolver.class, UpdateResolverResponse.Builder::resolver).handleResponseHeaderString("etag", UpdateResolverResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateResolverResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateResolverResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateResolverEndpointResponse updateResolverEndpoint(UpdateResolverEndpointRequest request) {
        Validate.notBlank((String)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResolverEndpointName(), (String)"resolverEndpointName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResolverEndpointDetails(), "updateResolverEndpointDetails is required");
        return (UpdateResolverEndpointResponse)this.clientCall(request, UpdateResolverEndpointResponse::builder).logger(LOG, "updateResolverEndpoint").serviceDetails("Dns", "UpdateResolverEndpoint", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/ResolverEndpoint/UpdateResolverEndpoint").method(Method.PUT).requestBuilder(UpdateResolverEndpointRequest::builder).basePath("/20180115").appendPathParam("resolvers").appendPathParam(request.getResolverId()).appendPathParam("endpoints").appendPathParam(request.getResolverEndpointName()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResolverEndpoint.class, UpdateResolverEndpointResponse.Builder::resolverEndpoint).handleResponseHeaderString("etag", UpdateResolverEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateResolverEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateResolverEndpointResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateSteeringPolicyResponse updateSteeringPolicy(UpdateSteeringPolicyRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyId(), (String)"steeringPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSteeringPolicyDetails(), "updateSteeringPolicyDetails is required");
        return (UpdateSteeringPolicyResponse)this.clientCall(request, UpdateSteeringPolicyResponse::builder).logger(LOG, "updateSteeringPolicy").serviceDetails("Dns", "UpdateSteeringPolicy", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicy/UpdateSteeringPolicy").method(Method.PUT).requestBuilder(UpdateSteeringPolicyRequest::builder).basePath("/20180115").appendPathParam("steeringPolicies").appendPathParam(request.getSteeringPolicyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SteeringPolicy.class, UpdateSteeringPolicyResponse.Builder::steeringPolicy).handleResponseHeaderString("opc-request-id", UpdateSteeringPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateSteeringPolicyResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateSteeringPolicyAttachmentResponse updateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request) {
        Validate.notBlank((String)request.getSteeringPolicyAttachmentId(), (String)"steeringPolicyAttachmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSteeringPolicyAttachmentDetails(), "updateSteeringPolicyAttachmentDetails is required");
        return (UpdateSteeringPolicyAttachmentResponse)this.clientCall(request, UpdateSteeringPolicyAttachmentResponse::builder).logger(LOG, "updateSteeringPolicyAttachment").serviceDetails("Dns", "UpdateSteeringPolicyAttachment", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/SteeringPolicyAttachment/UpdateSteeringPolicyAttachment").method(Method.PUT).requestBuilder(UpdateSteeringPolicyAttachmentRequest::builder).basePath("/20180115").appendPathParam("steeringPolicyAttachments").appendPathParam(request.getSteeringPolicyAttachmentId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SteeringPolicyAttachment.class, UpdateSteeringPolicyAttachmentResponse.Builder::steeringPolicyAttachment).handleResponseHeaderString("opc-request-id", UpdateSteeringPolicyAttachmentResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateSteeringPolicyAttachmentResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateTsigKeyResponse updateTsigKey(UpdateTsigKeyRequest request) {
        Validate.notBlank((String)request.getTsigKeyId(), (String)"tsigKeyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTsigKeyDetails(), "updateTsigKeyDetails is required");
        return (UpdateTsigKeyResponse)this.clientCall(request, UpdateTsigKeyResponse::builder).logger(LOG, "updateTsigKey").serviceDetails("Dns", "UpdateTsigKey", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/TsigKey/UpdateTsigKey").method(Method.PUT).requestBuilder(UpdateTsigKeyRequest::builder).basePath("/20180115").appendPathParam("tsigKeys").appendPathParam(request.getTsigKeyId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TsigKey.class, UpdateTsigKeyResponse.Builder::tsigKey).handleResponseHeaderString("ETag", UpdateTsigKeyResponse.Builder::eTag).handleResponseHeaderString("opc-request-id", UpdateTsigKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateTsigKeyResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateViewResponse updateView(UpdateViewRequest request) {
        Validate.notBlank((String)request.getViewId(), (String)"viewId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateViewDetails(), "updateViewDetails is required");
        return (UpdateViewResponse)this.clientCall(request, UpdateViewResponse::builder).logger(LOG, "updateView").serviceDetails("Dns", "UpdateView", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/View/UpdateView").method(Method.PUT).requestBuilder(UpdateViewRequest::builder).basePath("/20180115").appendPathParam("views").appendPathParam(request.getViewId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(View.class, UpdateViewResponse.Builder::view).handleResponseHeaderString("etag", UpdateViewResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateViewResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateViewResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateZoneResponse updateZone(UpdateZoneRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateZoneDetails(), "updateZoneDetails is required");
        return (UpdateZoneResponse)this.clientCall(request, UpdateZoneResponse::builder).logger(LOG, "updateZone").serviceDetails("Dns", "UpdateZone", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Zone/UpdateZone").method(Method.PUT).requestBuilder(UpdateZoneRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Zone.class, UpdateZoneResponse.Builder::zone).handleResponseHeaderString("ETag", UpdateZoneResponse.Builder::eTag).handleResponseHeaderString("opc-request-id", UpdateZoneResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateZoneResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateZoneRecordsResponse updateZoneRecords(UpdateZoneRecordsRequest request) {
        Validate.notBlank((String)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateZoneRecordsDetails(), "updateZoneRecordsDetails is required");
        return (UpdateZoneRecordsResponse)this.clientCall(request, UpdateZoneRecordsResponse::builder).logger(LOG, "updateZoneRecords").serviceDetails("Dns", "UpdateZoneRecords", "https://docs.oracle.com/iaas/api/#/en/dns/20180115/Records/UpdateZoneRecords").method(Method.PUT).requestBuilder(UpdateZoneRecordsRequest::builder).basePath("/20180115").appendPathParam("zones").appendPathParam(request.getZoneNameOrId()).appendPathParam("records").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("viewId", (Object)request.getViewId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("If-Match", request.getIfMatch()).appendHeader("If-Unmodified-Since", request.getIfUnmodifiedSince()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecordCollection.class, UpdateZoneRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-next-page", UpdateZoneRecordsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", UpdateZoneRecordsResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-request-id", UpdateZoneRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateZoneRecordsResponse.Builder::eTag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DnsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DnsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DnsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DnsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DnsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DnsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DnsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DnsClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

