/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrPlanRequest
extends BmcRequest<Void> {
    private String drPlanId;
    private String opcRequestId;

    public String getDrPlanId() {
        return this.drPlanId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().drPlanId(this.drPlanId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drPlanId=").append(String.valueOf(this.drPlanId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrPlanRequest)) {
            return false;
        }
        GetDrPlanRequest other = (GetDrPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drPlanId, other.drPlanId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drPlanId == null ? 43 : this.drPlanId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrPlanRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drPlanId = null;
        private String opcRequestId = null;

        public Builder drPlanId(String drPlanId) {
            this.drPlanId = drPlanId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrPlanRequest o) {
            this.drPlanId(o.getDrPlanId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrPlanRequest build() {
            GetDrPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrPlanRequest buildWithoutInvocationCallback() {
            GetDrPlanRequest request = new GetDrPlanRequest();
            request.drPlanId = this.drPlanId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

