/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery;

import com.oracle.bmc.disasterrecovery.DisasterRecovery;
import com.oracle.bmc.disasterrecovery.model.DrPlanExecutionSummary;
import com.oracle.bmc.disasterrecovery.model.DrPlanSummary;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroupSummary;
import com.oracle.bmc.disasterrecovery.model.WorkRequestError;
import com.oracle.bmc.disasterrecovery.model.WorkRequestLogEntry;
import com.oracle.bmc.disasterrecovery.model.WorkRequestSummary;
import com.oracle.bmc.disasterrecovery.requests.ListDrPlanExecutionsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListDrPlansRequest;
import com.oracle.bmc.disasterrecovery.requests.ListDrProtectionGroupsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.disasterrecovery.responses.ListDrPlanExecutionsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListDrPlansResponse;
import com.oracle.bmc.disasterrecovery.responses.ListDrProtectionGroupsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DisasterRecoveryPaginators {
    private final DisasterRecovery client;

    public DisasterRecoveryPaginators(DisasterRecovery client) {
        this.client = client;
    }

    public Iterable<ListDrPlanExecutionsResponse> listDrPlanExecutionsResponseIterator(final ListDrPlanExecutionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDrPlanExecutionsRequest.Builder>(){

            @Override
            public ListDrPlanExecutionsRequest.Builder get() {
                return ListDrPlanExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrPlanExecutionsResponse, String>(){

            @Override
            public String apply(ListDrPlanExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrPlanExecutionsRequest.Builder>, ListDrPlanExecutionsRequest>(){

            @Override
            public ListDrPlanExecutionsRequest apply(RequestBuilderAndToken<ListDrPlanExecutionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrPlanExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrPlanExecutionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrPlanExecutionsRequest, ListDrPlanExecutionsResponse>(){

            @Override
            public ListDrPlanExecutionsResponse apply(ListDrPlanExecutionsRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrPlanExecutions(request);
            }
        });
    }

    public Iterable<DrPlanExecutionSummary> listDrPlanExecutionsRecordIterator(final ListDrPlanExecutionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDrPlanExecutionsRequest.Builder>(){

            @Override
            public ListDrPlanExecutionsRequest.Builder get() {
                return ListDrPlanExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrPlanExecutionsResponse, String>(){

            @Override
            public String apply(ListDrPlanExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrPlanExecutionsRequest.Builder>, ListDrPlanExecutionsRequest>(){

            @Override
            public ListDrPlanExecutionsRequest apply(RequestBuilderAndToken<ListDrPlanExecutionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrPlanExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrPlanExecutionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrPlanExecutionsRequest, ListDrPlanExecutionsResponse>(){

            @Override
            public ListDrPlanExecutionsResponse apply(ListDrPlanExecutionsRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrPlanExecutions(request);
            }
        }, (Function)new Function<ListDrPlanExecutionsResponse, List<DrPlanExecutionSummary>>(){

            @Override
            public List<DrPlanExecutionSummary> apply(ListDrPlanExecutionsResponse response) {
                return response.getDrPlanExecutionCollection().getItems();
            }
        });
    }

    public Iterable<ListDrPlansResponse> listDrPlansResponseIterator(final ListDrPlansRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDrPlansRequest.Builder>(){

            @Override
            public ListDrPlansRequest.Builder get() {
                return ListDrPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrPlansResponse, String>(){

            @Override
            public String apply(ListDrPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrPlansRequest.Builder>, ListDrPlansRequest>(){

            @Override
            public ListDrPlansRequest apply(RequestBuilderAndToken<ListDrPlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrPlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrPlansRequest, ListDrPlansResponse>(){

            @Override
            public ListDrPlansResponse apply(ListDrPlansRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrPlans(request);
            }
        });
    }

    public Iterable<DrPlanSummary> listDrPlansRecordIterator(final ListDrPlansRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDrPlansRequest.Builder>(){

            @Override
            public ListDrPlansRequest.Builder get() {
                return ListDrPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrPlansResponse, String>(){

            @Override
            public String apply(ListDrPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrPlansRequest.Builder>, ListDrPlansRequest>(){

            @Override
            public ListDrPlansRequest apply(RequestBuilderAndToken<ListDrPlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrPlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrPlansRequest, ListDrPlansResponse>(){

            @Override
            public ListDrPlansResponse apply(ListDrPlansRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrPlans(request);
            }
        }, (Function)new Function<ListDrPlansResponse, List<DrPlanSummary>>(){

            @Override
            public List<DrPlanSummary> apply(ListDrPlansResponse response) {
                return response.getDrPlanCollection().getItems();
            }
        });
    }

    public Iterable<ListDrProtectionGroupsResponse> listDrProtectionGroupsResponseIterator(final ListDrProtectionGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDrProtectionGroupsRequest.Builder>(){

            @Override
            public ListDrProtectionGroupsRequest.Builder get() {
                return ListDrProtectionGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrProtectionGroupsResponse, String>(){

            @Override
            public String apply(ListDrProtectionGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrProtectionGroupsRequest.Builder>, ListDrProtectionGroupsRequest>(){

            @Override
            public ListDrProtectionGroupsRequest apply(RequestBuilderAndToken<ListDrProtectionGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrProtectionGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrProtectionGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrProtectionGroupsRequest, ListDrProtectionGroupsResponse>(){

            @Override
            public ListDrProtectionGroupsResponse apply(ListDrProtectionGroupsRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrProtectionGroups(request);
            }
        });
    }

    public Iterable<DrProtectionGroupSummary> listDrProtectionGroupsRecordIterator(final ListDrProtectionGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDrProtectionGroupsRequest.Builder>(){

            @Override
            public ListDrProtectionGroupsRequest.Builder get() {
                return ListDrProtectionGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrProtectionGroupsResponse, String>(){

            @Override
            public String apply(ListDrProtectionGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrProtectionGroupsRequest.Builder>, ListDrProtectionGroupsRequest>(){

            @Override
            public ListDrProtectionGroupsRequest apply(RequestBuilderAndToken<ListDrProtectionGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrProtectionGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrProtectionGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrProtectionGroupsRequest, ListDrProtectionGroupsResponse>(){

            @Override
            public ListDrProtectionGroupsResponse apply(ListDrProtectionGroupsRequest request) {
                return DisasterRecoveryPaginators.this.client.listDrProtectionGroups(request);
            }
        }, (Function)new Function<ListDrProtectionGroupsResponse, List<DrProtectionGroupSummary>>(){

            @Override
            public List<DrProtectionGroupSummary> apply(ListDrProtectionGroupsResponse response) {
                return response.getDrProtectionGroupCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DisasterRecoveryPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

