/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployArtifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class HelmRepositoryDeployArtifactSource
extends DeployArtifactSource {
    @JsonProperty(value="chartUrl")
    private final String chartUrl;
    @JsonProperty(value="deployArtifactVersion")
    private final String deployArtifactVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HelmRepositoryDeployArtifactSource(String chartUrl, String deployArtifactVersion) {
        this.chartUrl = chartUrl;
        this.deployArtifactVersion = deployArtifactVersion;
    }

    public String getChartUrl() {
        return this.chartUrl;
    }

    public String getDeployArtifactVersion() {
        return this.deployArtifactVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HelmRepositoryDeployArtifactSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", chartUrl=").append(String.valueOf(this.chartUrl));
        sb.append(", deployArtifactVersion=").append(String.valueOf(this.deployArtifactVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HelmRepositoryDeployArtifactSource)) {
            return false;
        }
        HelmRepositoryDeployArtifactSource other = (HelmRepositoryDeployArtifactSource)((Object)o);
        return Objects.equals(this.chartUrl, other.chartUrl) && Objects.equals(this.deployArtifactVersion, other.deployArtifactVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.chartUrl == null ? 43 : this.chartUrl.hashCode());
        result = result * 59 + (this.deployArtifactVersion == null ? 43 : this.deployArtifactVersion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="chartUrl")
        private String chartUrl;
        @JsonProperty(value="deployArtifactVersion")
        private String deployArtifactVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder chartUrl(String chartUrl) {
            this.chartUrl = chartUrl;
            this.__explicitlySet__.add("chartUrl");
            return this;
        }

        public Builder deployArtifactVersion(String deployArtifactVersion) {
            this.deployArtifactVersion = deployArtifactVersion;
            this.__explicitlySet__.add("deployArtifactVersion");
            return this;
        }

        public HelmRepositoryDeployArtifactSource build() {
            HelmRepositoryDeployArtifactSource model = new HelmRepositoryDeployArtifactSource(this.chartUrl, this.deployArtifactVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HelmRepositoryDeployArtifactSource model) {
            if (model.wasPropertyExplicitlySet("chartUrl")) {
                this.chartUrl(model.getChartUrl());
            }
            if (model.wasPropertyExplicitlySet("deployArtifactVersion")) {
                this.deployArtifactVersion(model.getDeployArtifactVersion());
            }
            return this;
        }
    }
}

