/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildPipelineStagePredecessorCollection;
import com.oracle.bmc.devops.model.BuildSourceCollection;
import com.oracle.bmc.devops.model.BuildStage;
import com.oracle.bmc.devops.model.CreateBuildPipelineStageDetails;
import com.oracle.bmc.devops.model.NetworkChannel;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildPipelineStageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateBuildStageDetails
extends CreateBuildPipelineStageDetails {
    @JsonProperty(value="image")
    private final BuildStage.Image image;
    @JsonProperty(value="buildSpecFile")
    private final String buildSpecFile;
    @JsonProperty(value="stageExecutionTimeoutInSeconds")
    private final Integer stageExecutionTimeoutInSeconds;
    @JsonProperty(value="buildSourceCollection")
    private final BuildSourceCollection buildSourceCollection;
    @JsonProperty(value="primaryBuildSource")
    private final String primaryBuildSource;
    @JsonProperty(value="privateAccessConfig")
    private final NetworkChannel privateAccessConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateBuildStageDetails(String displayName, String description, String buildPipelineId, BuildPipelineStagePredecessorCollection buildPipelineStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, BuildStage.Image image, String buildSpecFile, Integer stageExecutionTimeoutInSeconds, BuildSourceCollection buildSourceCollection, String primaryBuildSource, NetworkChannel privateAccessConfig) {
        super(displayName, description, buildPipelineId, buildPipelineStagePredecessorCollection, freeformTags, definedTags);
        this.image = image;
        this.buildSpecFile = buildSpecFile;
        this.stageExecutionTimeoutInSeconds = stageExecutionTimeoutInSeconds;
        this.buildSourceCollection = buildSourceCollection;
        this.primaryBuildSource = primaryBuildSource;
        this.privateAccessConfig = privateAccessConfig;
    }

    public BuildStage.Image getImage() {
        return this.image;
    }

    public String getBuildSpecFile() {
        return this.buildSpecFile;
    }

    public Integer getStageExecutionTimeoutInSeconds() {
        return this.stageExecutionTimeoutInSeconds;
    }

    public BuildSourceCollection getBuildSourceCollection() {
        return this.buildSourceCollection;
    }

    public String getPrimaryBuildSource() {
        return this.primaryBuildSource;
    }

    public NetworkChannel getPrivateAccessConfig() {
        return this.privateAccessConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBuildStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", image=").append(String.valueOf((Object)this.image));
        sb.append(", buildSpecFile=").append(String.valueOf(this.buildSpecFile));
        sb.append(", stageExecutionTimeoutInSeconds=").append(String.valueOf(this.stageExecutionTimeoutInSeconds));
        sb.append(", buildSourceCollection=").append(String.valueOf((Object)this.buildSourceCollection));
        sb.append(", primaryBuildSource=").append(String.valueOf(this.primaryBuildSource));
        sb.append(", privateAccessConfig=").append(String.valueOf((Object)this.privateAccessConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBuildStageDetails)) {
            return false;
        }
        CreateBuildStageDetails other = (CreateBuildStageDetails)((Object)o);
        return Objects.equals((Object)this.image, (Object)other.image) && Objects.equals(this.buildSpecFile, other.buildSpecFile) && Objects.equals(this.stageExecutionTimeoutInSeconds, other.stageExecutionTimeoutInSeconds) && Objects.equals((Object)this.buildSourceCollection, (Object)other.buildSourceCollection) && Objects.equals(this.primaryBuildSource, other.primaryBuildSource) && Objects.equals((Object)this.privateAccessConfig, (Object)other.privateAccessConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.buildSpecFile == null ? 43 : this.buildSpecFile.hashCode());
        result = result * 59 + (this.stageExecutionTimeoutInSeconds == null ? 43 : this.stageExecutionTimeoutInSeconds.hashCode());
        result = result * 59 + (this.buildSourceCollection == null ? 43 : this.buildSourceCollection.hashCode());
        result = result * 59 + (this.primaryBuildSource == null ? 43 : this.primaryBuildSource.hashCode());
        result = result * 59 + (this.privateAccessConfig == null ? 43 : this.privateAccessConfig.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="buildPipelineId")
        private String buildPipelineId;
        @JsonProperty(value="buildPipelineStagePredecessorCollection")
        private BuildPipelineStagePredecessorCollection buildPipelineStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="image")
        private BuildStage.Image image;
        @JsonProperty(value="buildSpecFile")
        private String buildSpecFile;
        @JsonProperty(value="stageExecutionTimeoutInSeconds")
        private Integer stageExecutionTimeoutInSeconds;
        @JsonProperty(value="buildSourceCollection")
        private BuildSourceCollection buildSourceCollection;
        @JsonProperty(value="primaryBuildSource")
        private String primaryBuildSource;
        @JsonProperty(value="privateAccessConfig")
        private NetworkChannel privateAccessConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder buildPipelineId(String buildPipelineId) {
            this.buildPipelineId = buildPipelineId;
            this.__explicitlySet__.add("buildPipelineId");
            return this;
        }

        public Builder buildPipelineStagePredecessorCollection(BuildPipelineStagePredecessorCollection buildPipelineStagePredecessorCollection) {
            this.buildPipelineStagePredecessorCollection = buildPipelineStagePredecessorCollection;
            this.__explicitlySet__.add("buildPipelineStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder image(BuildStage.Image image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder buildSpecFile(String buildSpecFile) {
            this.buildSpecFile = buildSpecFile;
            this.__explicitlySet__.add("buildSpecFile");
            return this;
        }

        public Builder stageExecutionTimeoutInSeconds(Integer stageExecutionTimeoutInSeconds) {
            this.stageExecutionTimeoutInSeconds = stageExecutionTimeoutInSeconds;
            this.__explicitlySet__.add("stageExecutionTimeoutInSeconds");
            return this;
        }

        public Builder buildSourceCollection(BuildSourceCollection buildSourceCollection) {
            this.buildSourceCollection = buildSourceCollection;
            this.__explicitlySet__.add("buildSourceCollection");
            return this;
        }

        public Builder primaryBuildSource(String primaryBuildSource) {
            this.primaryBuildSource = primaryBuildSource;
            this.__explicitlySet__.add("primaryBuildSource");
            return this;
        }

        public Builder privateAccessConfig(NetworkChannel privateAccessConfig) {
            this.privateAccessConfig = privateAccessConfig;
            this.__explicitlySet__.add("privateAccessConfig");
            return this;
        }

        public CreateBuildStageDetails build() {
            CreateBuildStageDetails model = new CreateBuildStageDetails(this.displayName, this.description, this.buildPipelineId, this.buildPipelineStagePredecessorCollection, this.freeformTags, this.definedTags, this.image, this.buildSpecFile, this.stageExecutionTimeoutInSeconds, this.buildSourceCollection, this.primaryBuildSource, this.privateAccessConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBuildStageDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineId")) {
                this.buildPipelineId(model.getBuildPipelineId());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineStagePredecessorCollection")) {
                this.buildPipelineStagePredecessorCollection(model.getBuildPipelineStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("buildSpecFile")) {
                this.buildSpecFile(model.getBuildSpecFile());
            }
            if (model.wasPropertyExplicitlySet("stageExecutionTimeoutInSeconds")) {
                this.stageExecutionTimeoutInSeconds(model.getStageExecutionTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("buildSourceCollection")) {
                this.buildSourceCollection(model.getBuildSourceCollection());
            }
            if (model.wasPropertyExplicitlySet("primaryBuildSource")) {
                this.primaryBuildSource(model.getPrimaryBuildSource());
            }
            if (model.wasPropertyExplicitlySet("privateAccessConfig")) {
                this.privateAccessConfig(model.getPrivateAccessConfig());
            }
            return this;
        }
    }
}

