/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.BitbucketCloudAppPasswordConnection;
import com.oracle.bmc.devops.model.BitbucketServerAccessTokenConnection;
import com.oracle.bmc.devops.model.GithubAccessTokenConnection;
import com.oracle.bmc.devops.model.GitlabAccessTokenConnection;
import com.oracle.bmc.devops.model.GitlabServerAccessTokenConnection;
import com.oracle.bmc.devops.model.VbsAccessTokenConnection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType", defaultImpl=Connection.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BitbucketServerAccessTokenConnection.class, name="BITBUCKET_SERVER_ACCESS_TOKEN"), @JsonSubTypes.Type(value=GitlabAccessTokenConnection.class, name="GITLAB_ACCESS_TOKEN"), @JsonSubTypes.Type(value=GithubAccessTokenConnection.class, name="GITHUB_ACCESS_TOKEN"), @JsonSubTypes.Type(value=BitbucketCloudAppPasswordConnection.class, name="BITBUCKET_CLOUD_APP_PASSWORD"), @JsonSubTypes.Type(value=GitlabServerAccessTokenConnection.class, name="GITLAB_SERVER_ACCESS_TOKEN"), @JsonSubTypes.Type(value=VbsAccessTokenConnection.class, name="VBS_ACCESS_TOKEN")})
@JsonFilter(value="explicitlySetFilter")
public class Connection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "description", "displayName", "compartmentId", "projectId", "timeCreated", "timeUpdated", "lifecycleState", "freeformTags", "definedTags", "systemTags"})
    protected Connection(String id, String description, String displayName, String compartmentId, String projectId, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.description = description;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.projectId = projectId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Connection(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConnectionType implements BmcEnum
    {
        GithubAccessToken("GITHUB_ACCESS_TOKEN"),
        GitlabAccessToken("GITLAB_ACCESS_TOKEN"),
        GitlabServerAccessToken("GITLAB_SERVER_ACCESS_TOKEN"),
        BitbucketServerAccessToken("BITBUCKET_SERVER_ACCESS_TOKEN"),
        BitbucketCloudAppPassword("BITBUCKET_CLOUD_APP_PASSWORD"),
        VbsAccessToken("VBS_ACCESS_TOKEN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConnectionType> map;

        private ConnectionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConnectionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConnectionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConnectionType.class);
            map = new HashMap<String, ConnectionType>();
            for (ConnectionType v : ConnectionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

