/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAvailableAuditVolumesRequest
extends BmcRequest<Void> {
    private String auditProfileId;
    private String workRequestId;
    private String trailLocation;
    private Date monthInConsiderationGreaterThan;
    private Date monthInConsiderationLessThan;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getAuditProfileId() {
        return this.auditProfileId;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getTrailLocation() {
        return this.trailLocation;
    }

    public Date getMonthInConsiderationGreaterThan() {
        return this.monthInConsiderationGreaterThan;
    }

    public Date getMonthInConsiderationLessThan() {
        return this.monthInConsiderationLessThan;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().auditProfileId(this.auditProfileId).workRequestId(this.workRequestId).trailLocation(this.trailLocation).monthInConsiderationGreaterThan(this.monthInConsiderationGreaterThan).monthInConsiderationLessThan(this.monthInConsiderationLessThan).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",auditProfileId=").append(String.valueOf(this.auditProfileId));
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",trailLocation=").append(String.valueOf(this.trailLocation));
        sb.append(",monthInConsiderationGreaterThan=").append(String.valueOf(this.monthInConsiderationGreaterThan));
        sb.append(",monthInConsiderationLessThan=").append(String.valueOf(this.monthInConsiderationLessThan));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAvailableAuditVolumesRequest)) {
            return false;
        }
        ListAvailableAuditVolumesRequest other = (ListAvailableAuditVolumesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.auditProfileId, other.auditProfileId) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.trailLocation, other.trailLocation) && Objects.equals(this.monthInConsiderationGreaterThan, other.monthInConsiderationGreaterThan) && Objects.equals(this.monthInConsiderationLessThan, other.monthInConsiderationLessThan) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.auditProfileId == null ? 43 : this.auditProfileId.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.trailLocation == null ? 43 : this.trailLocation.hashCode());
        result = result * 59 + (this.monthInConsiderationGreaterThan == null ? 43 : this.monthInConsiderationGreaterThan.hashCode());
        result = result * 59 + (this.monthInConsiderationLessThan == null ? 43 : this.monthInConsiderationLessThan.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAvailableAuditVolumesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String auditProfileId = null;
        private String workRequestId = null;
        private String trailLocation = null;
        private Date monthInConsiderationGreaterThan = null;
        private Date monthInConsiderationLessThan = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder auditProfileId(String auditProfileId) {
            this.auditProfileId = auditProfileId;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder trailLocation(String trailLocation) {
            this.trailLocation = trailLocation;
            return this;
        }

        public Builder monthInConsiderationGreaterThan(Date monthInConsiderationGreaterThan) {
            this.monthInConsiderationGreaterThan = monthInConsiderationGreaterThan;
            return this;
        }

        public Builder monthInConsiderationLessThan(Date monthInConsiderationLessThan) {
            this.monthInConsiderationLessThan = monthInConsiderationLessThan;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAvailableAuditVolumesRequest o) {
            this.auditProfileId(o.getAuditProfileId());
            this.workRequestId(o.getWorkRequestId());
            this.trailLocation(o.getTrailLocation());
            this.monthInConsiderationGreaterThan(o.getMonthInConsiderationGreaterThan());
            this.monthInConsiderationLessThan(o.getMonthInConsiderationLessThan());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAvailableAuditVolumesRequest build() {
            ListAvailableAuditVolumesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAvailableAuditVolumesRequest buildWithoutInvocationCallback() {
            ListAvailableAuditVolumesRequest request = new ListAvailableAuditVolumesRequest();
            request.auditProfileId = this.auditProfileId;
            request.workRequestId = this.workRequestId;
            request.trailLocation = this.trailLocation;
            request.monthInConsiderationGreaterThan = this.monthInConsiderationGreaterThan;
            request.monthInConsiderationLessThan = this.monthInConsiderationLessThan;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        MonthInConsideration("monthInConsideration"),
        Volume("volume"),
        TrailLocation("trailLocation");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

