/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Summary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isHidden")
    private final Boolean isHidden;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;
    @JsonProperty(value="groupByFieldName")
    private final String groupByFieldName;
    @JsonProperty(value="countOf")
    private final String countOf;
    @JsonProperty(value="scimFilter")
    private final String scimFilter;

    @Deprecated
    @ConstructorProperties(value={"name", "isHidden", "displayOrder", "groupByFieldName", "countOf", "scimFilter"})
    public Summary(String name, Boolean isHidden, Integer displayOrder, String groupByFieldName, String countOf, String scimFilter) {
        this.name = name;
        this.isHidden = isHidden;
        this.displayOrder = displayOrder;
        this.groupByFieldName = groupByFieldName;
        this.countOf = countOf;
        this.scimFilter = scimFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public String getCountOf() {
        return this.countOf;
    }

    public String getScimFilter() {
        return this.scimFilter;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Summary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", isHidden=").append(String.valueOf(this.isHidden));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(", groupByFieldName=").append(String.valueOf(this.groupByFieldName));
        sb.append(", countOf=").append(String.valueOf(this.countOf));
        sb.append(", scimFilter=").append(String.valueOf(this.scimFilter));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.displayOrder, other.displayOrder) && Objects.equals(this.groupByFieldName, other.groupByFieldName) && Objects.equals(this.countOf, other.countOf) && Objects.equals(this.scimFilter, other.scimFilter) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + (this.groupByFieldName == null ? 43 : this.groupByFieldName.hashCode());
        result = result * 59 + (this.countOf == null ? 43 : this.countOf.hashCode());
        result = result * 59 + (this.scimFilter == null ? 43 : this.scimFilter.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonProperty(value="groupByFieldName")
        private String groupByFieldName;
        @JsonProperty(value="countOf")
        private String countOf;
        @JsonProperty(value="scimFilter")
        private String scimFilter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public Builder groupByFieldName(String groupByFieldName) {
            this.groupByFieldName = groupByFieldName;
            this.__explicitlySet__.add("groupByFieldName");
            return this;
        }

        public Builder countOf(String countOf) {
            this.countOf = countOf;
            this.__explicitlySet__.add("countOf");
            return this;
        }

        public Builder scimFilter(String scimFilter) {
            this.scimFilter = scimFilter;
            this.__explicitlySet__.add("scimFilter");
            return this;
        }

        public Summary build() {
            Summary model = new Summary(this.name, this.isHidden, this.displayOrder, this.groupByFieldName, this.countOf, this.scimFilter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Summary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            if (model.wasPropertyExplicitlySet("groupByFieldName")) {
                this.groupByFieldName(model.getGroupByFieldName());
            }
            if (model.wasPropertyExplicitlySet("countOf")) {
                this.countOf(model.getCountOf());
            }
            if (model.wasPropertyExplicitlySet("scimFilter")) {
                this.scimFilter(model.getScimFilter());
            }
            return this;
        }
    }
}

