/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class PPFFormatEntry
extends FormatEntry {
    @JsonProperty(value="postProcessingFunction")
    private final String postProcessingFunction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PPFFormatEntry(String description, String postProcessingFunction) {
        super(description);
        this.postProcessingFunction = postProcessingFunction;
    }

    public String getPostProcessingFunction() {
        return this.postProcessingFunction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PPFFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", postProcessingFunction=").append(String.valueOf(this.postProcessingFunction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PPFFormatEntry)) {
            return false;
        }
        PPFFormatEntry other = (PPFFormatEntry)((Object)o);
        return Objects.equals(this.postProcessingFunction, other.postProcessingFunction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.postProcessingFunction == null ? 43 : this.postProcessingFunction.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="postProcessingFunction")
        private String postProcessingFunction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder postProcessingFunction(String postProcessingFunction) {
            this.postProcessingFunction = postProcessingFunction;
            this.__explicitlySet__.add("postProcessingFunction");
            return this;
        }

        public PPFFormatEntry build() {
            PPFFormatEntry model = new PPFFormatEntry(this.description, this.postProcessingFunction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PPFFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("postProcessingFunction")) {
                this.postProcessingFunction(model.getPostProcessingFunction());
            }
            return this;
        }
    }
}

