/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.Finding;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Diffs
extends ExplicitlySetBmcModel {
    @JsonProperty(value="current")
    private final Finding current;
    @JsonProperty(value="baseline")
    private final Finding baseline;
    @JsonProperty(value="removedItems")
    private final List<String> removedItems;
    @JsonProperty(value="addedItems")
    private final List<String> addedItems;
    @JsonProperty(value="modifiedItems")
    private final List<String> modifiedItems;
    @JsonProperty(value="severity")
    private final Severity severity;

    @Deprecated
    @ConstructorProperties(value={"current", "baseline", "removedItems", "addedItems", "modifiedItems", "severity"})
    public Diffs(Finding current, Finding baseline, List<String> removedItems, List<String> addedItems, List<String> modifiedItems, Severity severity) {
        this.current = current;
        this.baseline = baseline;
        this.removedItems = removedItems;
        this.addedItems = addedItems;
        this.modifiedItems = modifiedItems;
        this.severity = severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Finding getCurrent() {
        return this.current;
    }

    public Finding getBaseline() {
        return this.baseline;
    }

    public List<String> getRemovedItems() {
        return this.removedItems;
    }

    public List<String> getAddedItems() {
        return this.addedItems;
    }

    public List<String> getModifiedItems() {
        return this.modifiedItems;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Diffs(");
        sb.append("super=").append(super.toString());
        sb.append("current=").append(String.valueOf((Object)this.current));
        sb.append(", baseline=").append(String.valueOf((Object)this.baseline));
        sb.append(", removedItems=").append(String.valueOf(this.removedItems));
        sb.append(", addedItems=").append(String.valueOf(this.addedItems));
        sb.append(", modifiedItems=").append(String.valueOf(this.modifiedItems));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Diffs)) {
            return false;
        }
        Diffs other = (Diffs)((Object)o);
        return Objects.equals((Object)this.current, (Object)other.current) && Objects.equals((Object)this.baseline, (Object)other.baseline) && Objects.equals(this.removedItems, other.removedItems) && Objects.equals(this.addedItems, other.addedItems) && Objects.equals(this.modifiedItems, other.modifiedItems) && Objects.equals((Object)this.severity, (Object)other.severity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.current == null ? 43 : this.current.hashCode());
        result = result * 59 + (this.baseline == null ? 43 : this.baseline.hashCode());
        result = result * 59 + (this.removedItems == null ? 43 : this.removedItems.hashCode());
        result = result * 59 + (this.addedItems == null ? 43 : this.addedItems.hashCode());
        result = result * 59 + (this.modifiedItems == null ? 43 : this.modifiedItems.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Evaluate("EVALUATE"),
        Advisory("ADVISORY"),
        Pass("PASS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="current")
        private Finding current;
        @JsonProperty(value="baseline")
        private Finding baseline;
        @JsonProperty(value="removedItems")
        private List<String> removedItems;
        @JsonProperty(value="addedItems")
        private List<String> addedItems;
        @JsonProperty(value="modifiedItems")
        private List<String> modifiedItems;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder current(Finding current) {
            this.current = current;
            this.__explicitlySet__.add("current");
            return this;
        }

        public Builder baseline(Finding baseline) {
            this.baseline = baseline;
            this.__explicitlySet__.add("baseline");
            return this;
        }

        public Builder removedItems(List<String> removedItems) {
            this.removedItems = removedItems;
            this.__explicitlySet__.add("removedItems");
            return this;
        }

        public Builder addedItems(List<String> addedItems) {
            this.addedItems = addedItems;
            this.__explicitlySet__.add("addedItems");
            return this;
        }

        public Builder modifiedItems(List<String> modifiedItems) {
            this.modifiedItems = modifiedItems;
            this.__explicitlySet__.add("modifiedItems");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Diffs build() {
            Diffs model = new Diffs(this.current, this.baseline, this.removedItems, this.addedItems, this.modifiedItems, this.severity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Diffs model) {
            if (model.wasPropertyExplicitlySet("current")) {
                this.current(model.getCurrent());
            }
            if (model.wasPropertyExplicitlySet("baseline")) {
                this.baseline(model.getBaseline());
            }
            if (model.wasPropertyExplicitlySet("removedItems")) {
                this.removedItems(model.getRemovedItems());
            }
            if (model.wasPropertyExplicitlySet("addedItems")) {
                this.addedItems(model.getAddedItems());
            }
            if (model.wasPropertyExplicitlySet("modifiedItems")) {
                this.modifiedItems(model.getModifiedItems());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            return this;
        }
    }
}

