/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.GlobalSettings;
import com.oracle.bmc.datasafe.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataSafeConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeEnabled")
    private final Date timeEnabled;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="dataSafeNatGatewayIpAddress")
    private final String dataSafeNatGatewayIpAddress;
    @JsonProperty(value="globalSettings")
    private final GlobalSettings globalSettings;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "url", "compartmentId", "timeEnabled", "lifecycleState", "dataSafeNatGatewayIpAddress", "globalSettings", "freeformTags", "definedTags"})
    public DataSafeConfiguration(Boolean isEnabled, String url, String compartmentId, Date timeEnabled, LifecycleState lifecycleState, String dataSafeNatGatewayIpAddress, GlobalSettings globalSettings, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.isEnabled = isEnabled;
        this.url = url;
        this.compartmentId = compartmentId;
        this.timeEnabled = timeEnabled;
        this.lifecycleState = lifecycleState;
        this.dataSafeNatGatewayIpAddress = dataSafeNatGatewayIpAddress;
        this.globalSettings = globalSettings;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeEnabled() {
        return this.timeEnabled;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDataSafeNatGatewayIpAddress() {
        return this.dataSafeNatGatewayIpAddress;
    }

    public GlobalSettings getGlobalSettings() {
        return this.globalSettings;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataSafeConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeEnabled=").append(String.valueOf(this.timeEnabled));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", dataSafeNatGatewayIpAddress=").append(String.valueOf(this.dataSafeNatGatewayIpAddress));
        sb.append(", globalSettings=").append(String.valueOf((Object)this.globalSettings));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSafeConfiguration)) {
            return false;
        }
        DataSafeConfiguration other = (DataSafeConfiguration)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.url, other.url) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeEnabled, other.timeEnabled) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.dataSafeNatGatewayIpAddress, other.dataSafeNatGatewayIpAddress) && Objects.equals((Object)this.globalSettings, (Object)other.globalSettings) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeEnabled == null ? 43 : this.timeEnabled.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.dataSafeNatGatewayIpAddress == null ? 43 : this.dataSafeNatGatewayIpAddress.hashCode());
        result = result * 59 + (this.globalSettings == null ? 43 : this.globalSettings.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeEnabled")
        private Date timeEnabled;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="dataSafeNatGatewayIpAddress")
        private String dataSafeNatGatewayIpAddress;
        @JsonProperty(value="globalSettings")
        private GlobalSettings globalSettings;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeEnabled(Date timeEnabled) {
            this.timeEnabled = timeEnabled;
            this.__explicitlySet__.add("timeEnabled");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder dataSafeNatGatewayIpAddress(String dataSafeNatGatewayIpAddress) {
            this.dataSafeNatGatewayIpAddress = dataSafeNatGatewayIpAddress;
            this.__explicitlySet__.add("dataSafeNatGatewayIpAddress");
            return this;
        }

        public Builder globalSettings(GlobalSettings globalSettings) {
            this.globalSettings = globalSettings;
            this.__explicitlySet__.add("globalSettings");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public DataSafeConfiguration build() {
            DataSafeConfiguration model = new DataSafeConfiguration(this.isEnabled, this.url, this.compartmentId, this.timeEnabled, this.lifecycleState, this.dataSafeNatGatewayIpAddress, this.globalSettings, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataSafeConfiguration model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeEnabled")) {
                this.timeEnabled(model.getTimeEnabled());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("dataSafeNatGatewayIpAddress")) {
                this.dataSafeNatGatewayIpAddress(model.getDataSafeNatGatewayIpAddress());
            }
            if (model.wasPropertyExplicitlySet("globalSettings")) {
                this.globalSettings(model.getGlobalSettings());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

