/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ColumnSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="length")
    private final Long length;
    @JsonProperty(value="precision")
    private final Integer precision;
    @JsonProperty(value="scale")
    private final Integer scale;
    @JsonProperty(value="characterLength")
    private final Integer characterLength;
    @JsonProperty(value="tableName")
    private final String tableName;
    @JsonProperty(value="schemaName")
    private final String schemaName;

    @Deprecated
    @ConstructorProperties(value={"columnName", "dataType", "length", "precision", "scale", "characterLength", "tableName", "schemaName"})
    public ColumnSummary(String columnName, String dataType, Long length, Integer precision, Integer scale, Integer characterLength, String tableName, String schemaName) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.characterLength = characterLength;
        this.tableName = tableName;
        this.schemaName = schemaName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Long getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getCharacterLength() {
        return this.characterLength;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnSummary(");
        sb.append("super=").append(super.toString());
        sb.append("columnName=").append(String.valueOf(this.columnName));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", length=").append(String.valueOf(this.length));
        sb.append(", precision=").append(String.valueOf(this.precision));
        sb.append(", scale=").append(String.valueOf(this.scale));
        sb.append(", characterLength=").append(String.valueOf(this.characterLength));
        sb.append(", tableName=").append(String.valueOf(this.tableName));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnSummary)) {
            return false;
        }
        ColumnSummary other = (ColumnSummary)((Object)o);
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.length, other.length) && Objects.equals(this.precision, other.precision) && Objects.equals(this.scale, other.scale) && Objects.equals(this.characterLength, other.characterLength) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.schemaName, other.schemaName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        result = result * 59 + (this.precision == null ? 43 : this.precision.hashCode());
        result = result * 59 + (this.scale == null ? 43 : this.scale.hashCode());
        result = result * 59 + (this.characterLength == null ? 43 : this.characterLength.hashCode());
        result = result * 59 + (this.tableName == null ? 43 : this.tableName.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="length")
        private Long length;
        @JsonProperty(value="precision")
        private Integer precision;
        @JsonProperty(value="scale")
        private Integer scale;
        @JsonProperty(value="characterLength")
        private Integer characterLength;
        @JsonProperty(value="tableName")
        private String tableName;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder length(Long length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = precision;
            this.__explicitlySet__.add("precision");
            return this;
        }

        public Builder scale(Integer scale) {
            this.scale = scale;
            this.__explicitlySet__.add("scale");
            return this;
        }

        public Builder characterLength(Integer characterLength) {
            this.characterLength = characterLength;
            this.__explicitlySet__.add("characterLength");
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            this.__explicitlySet__.add("tableName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public ColumnSummary build() {
            ColumnSummary model = new ColumnSummary(this.columnName, this.dataType, this.length, this.precision, this.scale, this.characterLength, this.tableName, this.schemaName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ColumnSummary model) {
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            if (model.wasPropertyExplicitlySet("precision")) {
                this.precision(model.getPrecision());
            }
            if (model.wasPropertyExplicitlySet("scale")) {
                this.scale(model.getScale());
            }
            if (model.wasPropertyExplicitlySet("characterLength")) {
                this.characterLength(model.getCharacterLength());
            }
            if (model.wasPropertyExplicitlySet("tableName")) {
                this.tableName(model.getTableName());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            return this;
        }
    }
}

