/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datalabelingservicedataplane.model.UpdateRecordDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRecordRequest
extends BmcRequest<UpdateRecordDetails> {
    private String recordId;
    private UpdateRecordDetails updateRecordDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getRecordId() {
        return this.recordId;
    }

    public UpdateRecordDetails getUpdateRecordDetails() {
        return this.updateRecordDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateRecordDetails getBody$() {
        return this.updateRecordDetails;
    }

    public Builder toBuilder() {
        return new Builder().recordId(this.recordId).updateRecordDetails(this.updateRecordDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",recordId=").append(String.valueOf(this.recordId));
        sb.append(",updateRecordDetails=").append(String.valueOf((Object)this.updateRecordDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRecordRequest)) {
            return false;
        }
        UpdateRecordRequest other = (UpdateRecordRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.recordId, other.recordId) && Objects.equals((Object)this.updateRecordDetails, (Object)other.updateRecordDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recordId == null ? 43 : this.recordId.hashCode());
        result = result * 59 + (this.updateRecordDetails == null ? 43 : this.updateRecordDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRecordRequest, UpdateRecordDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String recordId = null;
        private UpdateRecordDetails updateRecordDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public Builder updateRecordDetails(UpdateRecordDetails updateRecordDetails) {
            this.updateRecordDetails = updateRecordDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRecordRequest o) {
            this.recordId(o.getRecordId());
            this.updateRecordDetails(o.getUpdateRecordDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRecordRequest build() {
            UpdateRecordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRecordDetails body) {
            this.updateRecordDetails(body);
            return this;
        }

        public UpdateRecordRequest buildWithoutInvocationCallback() {
            UpdateRecordRequest request = new UpdateRecordRequest();
            request.recordId = this.recordId;
            request.updateRecordDetails = this.updateRecordDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

