/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datalabelingservicedataplane.model.Annotation;
import com.oracle.bmc.datalabelingservicedataplane.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SummarizeAnnotationAnalyticsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String datasetId;
    private Annotation.LifecycleState lifecycleState;
    private String label;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private AnnotationGroupBy annotationGroupBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public Annotation.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLabel() {
        return this.label;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public AnnotationGroupBy getAnnotationGroupBy() {
        return this.annotationGroupBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).datasetId(this.datasetId).lifecycleState(this.lifecycleState).label(this.label).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).annotationGroupBy(this.annotationGroupBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",datasetId=").append(String.valueOf(this.datasetId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",label=").append(String.valueOf(this.label));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",annotationGroupBy=").append(String.valueOf((Object)this.annotationGroupBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeAnnotationAnalyticsRequest)) {
            return false;
        }
        SummarizeAnnotationAnalyticsRequest other = (SummarizeAnnotationAnalyticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.datasetId, other.datasetId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.label, other.label) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.annotationGroupBy, (Object)other.annotationGroupBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.datasetId == null ? 43 : this.datasetId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.annotationGroupBy == null ? 43 : this.annotationGroupBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeAnnotationAnalyticsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String datasetId = null;
        private Annotation.LifecycleState lifecycleState = null;
        private String label = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private AnnotationGroupBy annotationGroupBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public Builder lifecycleState(Annotation.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder annotationGroupBy(AnnotationGroupBy annotationGroupBy) {
            this.annotationGroupBy = annotationGroupBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeAnnotationAnalyticsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.datasetId(o.getDatasetId());
            this.lifecycleState(o.getLifecycleState());
            this.label(o.getLabel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.annotationGroupBy(o.getAnnotationGroupBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeAnnotationAnalyticsRequest build() {
            SummarizeAnnotationAnalyticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeAnnotationAnalyticsRequest buildWithoutInvocationCallback() {
            SummarizeAnnotationAnalyticsRequest request = new SummarizeAnnotationAnalyticsRequest();
            request.compartmentId = this.compartmentId;
            request.datasetId = this.datasetId;
            request.lifecycleState = this.lifecycleState;
            request.label = this.label;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.annotationGroupBy = this.annotationGroupBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum AnnotationGroupBy implements BmcEnum
    {
        UpdatedBy("updatedBy"),
        Label("label");

        private final String value;
        private static Map<String, AnnotationGroupBy> map;

        private AnnotationGroupBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AnnotationGroupBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AnnotationGroupBy: " + key);
        }

        static {
            map = new HashMap<String, AnnotationGroupBy>();
            for (AnnotationGroupBy v : AnnotationGroupBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Count("count"),
        Label("label"),
        UpdatedBy("updatedBy");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

