/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datalabelingservicedataplane.DataLabeling;
import com.oracle.bmc.datalabelingservicedataplane.DataLabelingAsyncClient;
import com.oracle.bmc.datalabelingservicedataplane.DataLabelingPaginators;
import com.oracle.bmc.datalabelingservicedataplane.DataLabelingWaiters;
import com.oracle.bmc.datalabelingservicedataplane.model.Annotation;
import com.oracle.bmc.datalabelingservicedataplane.model.AnnotationAnalyticsAggregationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.AnnotationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.Dataset;
import com.oracle.bmc.datalabelingservicedataplane.model.Record;
import com.oracle.bmc.datalabelingservicedataplane.model.RecordAnalyticsAggregationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.RecordCollection;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordPreviewContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListAnnotationsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListRecordsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeAnnotationAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeRecordAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordPreviewContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListAnnotationsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListRecordsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeAnnotationAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeRecordAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateRecordResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLabelingClient
extends BaseSyncClient
implements DataLabeling {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATALABELING").serviceEndpointPrefix("").serviceEndpointTemplate("https://datalabeling-dp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataLabelingAsyncClient.class);
    private final DataLabelingWaiters waiters;
    private final DataLabelingPaginators paginators;

    private DataLabelingClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataLabeling-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataLabelingWaiters(executorService, this);
        this.paginators = new DataLabelingPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateAnnotationResponse createAnnotation(CreateAnnotationRequest request) {
        Objects.requireNonNull(request.getCreateAnnotationDetails(), "createAnnotationDetails is required");
        return (CreateAnnotationResponse)this.clientCall(request, CreateAnnotationResponse::builder).logger(LOG, "createAnnotation").serviceDetails("DataLabeling", "CreateAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/CreateAnnotation").method(Method.POST).requestBuilder(CreateAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Annotation.class, CreateAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", CreateAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAnnotationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateRecordResponse createRecord(CreateRecordRequest request) {
        Objects.requireNonNull(request.getCreateRecordDetails(), "createRecordDetails is required");
        return (CreateRecordResponse)this.clientCall(request, CreateRecordResponse::builder).logger(LOG, "createRecord").serviceDetails("DataLabeling", "CreateRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/CreateRecord").method(Method.POST).requestBuilder(CreateRecordRequest::builder).basePath("/20211001").appendPathParam("records").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Record.class, CreateRecordResponse.Builder::record).handleResponseHeaderString("etag", CreateRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRecordResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteAnnotationResponse deleteAnnotation(DeleteAnnotationRequest request) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        return (DeleteAnnotationResponse)this.clientCall(request, DeleteAnnotationResponse::builder).logger(LOG, "deleteAnnotation").serviceDetails("DataLabeling", "DeleteAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/DeleteAnnotation").method(Method.DELETE).requestBuilder(DeleteAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAnnotationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteRecordResponse deleteRecord(DeleteRecordRequest request) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return (DeleteRecordResponse)this.clientCall(request, DeleteRecordResponse::builder).logger(LOG, "deleteRecord").serviceDetails("DataLabeling", "DeleteRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/DeleteRecord").method(Method.DELETE).requestBuilder(DeleteRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRecordResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAnnotationResponse getAnnotation(GetAnnotationRequest request) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        return (GetAnnotationResponse)this.clientCall(request, GetAnnotationResponse::builder).logger(LOG, "getAnnotation").serviceDetails("DataLabeling", "GetAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/GetAnnotation").method(Method.GET).requestBuilder(GetAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Annotation.class, GetAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", GetAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnnotationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetDatasetResponse getDataset(GetDatasetRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return (GetDatasetResponse)this.clientCall(request, GetDatasetResponse::builder).logger(LOG, "getDataset").serviceDetails("DataLabeling", "GetDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Dataset/GetDataset").method(Method.GET).requestBuilder(GetDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Dataset.class, GetDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", GetDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatasetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRecordResponse getRecord(GetRecordRequest request) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return (GetRecordResponse)this.clientCall(request, GetRecordResponse::builder).logger(LOG, "getRecord").serviceDetails("DataLabeling", "GetRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecord").method(Method.GET).requestBuilder(GetRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Record.class, GetRecordResponse.Builder::record).handleResponseHeaderString("etag", GetRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRecordContentResponse getRecordContent(GetRecordContentRequest request) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return (GetRecordContentResponse)this.clientCall(request, GetRecordContentResponse::builder).logger(LOG, "getRecordContent").serviceDetails("DataLabeling", "GetRecordContent", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecordContent").method(Method.GET).requestBuilder(GetRecordContentRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(InputStream.class, GetRecordContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetRecordContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetRecordContentResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", GetRecordContentResponse.Builder::contentDisposition).handleResponseHeaderString("content-type", GetRecordContentResponse.Builder::contentType).handleResponseHeaderString("cache-control", GetRecordContentResponse.Builder::cacheControl).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRecordPreviewContentResponse getRecordPreviewContent(GetRecordPreviewContentRequest request) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return (GetRecordPreviewContentResponse)this.clientCall(request, GetRecordPreviewContentResponse::builder).logger(LOG, "getRecordPreviewContent").serviceDetails("DataLabeling", "GetRecordPreviewContent", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecordPreviewContent").method(Method.GET).requestBuilder(GetRecordPreviewContentRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).appendPathParam("preview").appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(InputStream.class, GetRecordPreviewContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetRecordPreviewContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordPreviewContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetRecordPreviewContentResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", GetRecordPreviewContentResponse.Builder::contentDisposition).handleResponseHeaderString("content-type", GetRecordPreviewContentResponse.Builder::contentType).handleResponseHeaderString("cache-control", GetRecordPreviewContentResponse.Builder::cacheControl).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAnnotationsResponse listAnnotations(ListAnnotationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return (ListAnnotationsResponse)this.clientCall(request, ListAnnotationsResponse::builder).logger(LOG, "listAnnotations").serviceDetails("DataLabeling", "ListAnnotations", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/AnnotationCollection/ListAnnotations").method(Method.GET).requestBuilder(ListAnnotationsRequest::builder).basePath("/20211001").appendPathParam("annotations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("updatedBy", (Object)request.getUpdatedBy()).appendQueryParam("recordId", (Object)request.getRecordId()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThanOrEqualTo", (Object)request.getTimeCreatedLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnotationCollection.class, ListAnnotationsResponse.Builder::annotationCollection).handleResponseHeaderString("opc-request-id", ListAnnotationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnotationsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRecordsResponse listRecords(ListRecordsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return (ListRecordsResponse)this.clientCall(request, ListRecordsResponse::builder).logger(LOG, "listRecords").serviceDetails("DataLabeling", "ListRecords", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/RecordCollection/ListRecords").method(Method.GET).requestBuilder(ListRecordsRequest::builder).basePath("/20211001").appendPathParam("records").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("isLabeled", (Object)request.getIsLabeled()).appendListQueryParam("annotationLabelsContains", request.getAnnotationLabelsContains(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordCollection.class, ListRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-request-id", ListRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecordsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeAnnotationAnalyticsResponse summarizeAnnotationAnalytics(SummarizeAnnotationAnalyticsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return (SummarizeAnnotationAnalyticsResponse)this.clientCall(request, SummarizeAnnotationAnalyticsResponse::builder).logger(LOG, "summarizeAnnotationAnalytics").serviceDetails("DataLabeling", "SummarizeAnnotationAnalytics", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/AnnotationAnalyticsAggregationCollection/SummarizeAnnotationAnalytics").method(Method.GET).requestBuilder(SummarizeAnnotationAnalyticsRequest::builder).basePath("/20211001").appendPathParam("annotationAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("label", (Object)request.getLabel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("annotationGroupBy", (BmcEnum)request.getAnnotationGroupBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnotationAnalyticsAggregationCollection.class, SummarizeAnnotationAnalyticsResponse.Builder::annotationAnalyticsAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeAnnotationAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAnnotationAnalyticsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeRecordAnalyticsResponse summarizeRecordAnalytics(SummarizeRecordAnalyticsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return (SummarizeRecordAnalyticsResponse)this.clientCall(request, SummarizeRecordAnalyticsResponse::builder).logger(LOG, "summarizeRecordAnalytics").serviceDetails("DataLabeling", "SummarizeRecordAnalytics", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/RecordAnalyticsAggregationCollection/SummarizeRecordAnalytics").method(Method.GET).requestBuilder(SummarizeRecordAnalyticsRequest::builder).basePath("/20211001").appendPathParam("recordAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("recordGroupBy", (BmcEnum)request.getRecordGroupBy()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordAnalyticsAggregationCollection.class, SummarizeRecordAnalyticsResponse.Builder::recordAnalyticsAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeRecordAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeRecordAnalyticsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAnnotationResponse updateAnnotation(UpdateAnnotationRequest request) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnnotationDetails(), "updateAnnotationDetails is required");
        return (UpdateAnnotationResponse)this.clientCall(request, UpdateAnnotationResponse::builder).logger(LOG, "updateAnnotation").serviceDetails("DataLabeling", "UpdateAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/UpdateAnnotation").method(Method.PUT).requestBuilder(UpdateAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Annotation.class, UpdateAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", UpdateAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAnnotationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRecordResponse updateRecord(UpdateRecordRequest request) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecordDetails(), "updateRecordDetails is required");
        return (UpdateRecordResponse)this.clientCall(request, UpdateRecordResponse::builder).logger(LOG, "updateRecord").serviceDetails("DataLabeling", "UpdateRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/UpdateRecord").method(Method.PUT).requestBuilder(UpdateRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Record.class, UpdateRecordResponse.Builder::record).handleResponseHeaderString("etag", UpdateRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRecordResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DataLabelingWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataLabelingPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DataLabelingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataLabelingClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataLabelingClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataLabelingClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataLabelingClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataLabelingClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

