/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datalabelingservice.model.RenameDatasetLabelsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RenameDatasetLabelsRequest
extends BmcRequest<RenameDatasetLabelsDetails> {
    private String datasetId;
    private RenameDatasetLabelsDetails renameDatasetLabelsDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getDatasetId() {
        return this.datasetId;
    }

    public RenameDatasetLabelsDetails getRenameDatasetLabelsDetails() {
        return this.renameDatasetLabelsDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RenameDatasetLabelsDetails getBody$() {
        return this.renameDatasetLabelsDetails;
    }

    public Builder toBuilder() {
        return new Builder().datasetId(this.datasetId).renameDatasetLabelsDetails(this.renameDatasetLabelsDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",datasetId=").append(String.valueOf(this.datasetId));
        sb.append(",renameDatasetLabelsDetails=").append(String.valueOf((Object)this.renameDatasetLabelsDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenameDatasetLabelsRequest)) {
            return false;
        }
        RenameDatasetLabelsRequest other = (RenameDatasetLabelsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.datasetId, other.datasetId) && Objects.equals((Object)this.renameDatasetLabelsDetails, (Object)other.renameDatasetLabelsDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.datasetId == null ? 43 : this.datasetId.hashCode());
        result = result * 59 + (this.renameDatasetLabelsDetails == null ? 43 : this.renameDatasetLabelsDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RenameDatasetLabelsRequest, RenameDatasetLabelsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String datasetId = null;
        private RenameDatasetLabelsDetails renameDatasetLabelsDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public Builder renameDatasetLabelsDetails(RenameDatasetLabelsDetails renameDatasetLabelsDetails) {
            this.renameDatasetLabelsDetails = renameDatasetLabelsDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RenameDatasetLabelsRequest o) {
            this.datasetId(o.getDatasetId());
            this.renameDatasetLabelsDetails(o.getRenameDatasetLabelsDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RenameDatasetLabelsRequest build() {
            RenameDatasetLabelsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RenameDatasetLabelsDetails body) {
            this.renameDatasetLabelsDetails(body);
            return this;
        }

        public RenameDatasetLabelsRequest buildWithoutInvocationCallback() {
            RenameDatasetLabelsRequest request = new RenameDatasetLabelsRequest();
            request.datasetId = this.datasetId;
            request.renameDatasetLabelsDetails = this.renameDatasetLabelsDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

