/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateDataFlowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDataFlowRequest
extends BmcRequest<UpdateDataFlowDetails> {
    private String workspaceId;
    private String dataFlowKey;
    private UpdateDataFlowDetails updateDataFlowDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataFlowKey() {
        return this.dataFlowKey;
    }

    public UpdateDataFlowDetails getUpdateDataFlowDetails() {
        return this.updateDataFlowDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDataFlowDetails getBody$() {
        return this.updateDataFlowDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).dataFlowKey(this.dataFlowKey).updateDataFlowDetails(this.updateDataFlowDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",dataFlowKey=").append(String.valueOf(this.dataFlowKey));
        sb.append(",updateDataFlowDetails=").append(String.valueOf((Object)this.updateDataFlowDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataFlowRequest)) {
            return false;
        }
        UpdateDataFlowRequest other = (UpdateDataFlowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.dataFlowKey, other.dataFlowKey) && Objects.equals((Object)this.updateDataFlowDetails, (Object)other.updateDataFlowDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.dataFlowKey == null ? 43 : this.dataFlowKey.hashCode());
        result = result * 59 + (this.updateDataFlowDetails == null ? 43 : this.updateDataFlowDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDataFlowRequest, UpdateDataFlowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String dataFlowKey = null;
        private UpdateDataFlowDetails updateDataFlowDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataFlowKey(String dataFlowKey) {
            this.dataFlowKey = dataFlowKey;
            return this;
        }

        public Builder updateDataFlowDetails(UpdateDataFlowDetails updateDataFlowDetails) {
            this.updateDataFlowDetails = updateDataFlowDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDataFlowRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataFlowKey(o.getDataFlowKey());
            this.updateDataFlowDetails(o.getUpdateDataFlowDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDataFlowRequest build() {
            UpdateDataFlowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDataFlowDetails body) {
            this.updateDataFlowDetails(body);
            return this;
        }

        public UpdateDataFlowRequest buildWithoutInvocationCallback() {
            UpdateDataFlowRequest request = new UpdateDataFlowRequest();
            request.workspaceId = this.workspaceId;
            request.dataFlowKey = this.dataFlowKey;
            request.updateDataFlowDetails = this.updateDataFlowDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

