/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDataEntitiesRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private String name;
    private String page;
    private String type;
    private Integer limit;
    private List<String> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private List<String> nameList;
    private Boolean isPattern;
    private List<String> includeTypes;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public String getType() {
        return this.type;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public Boolean getIsPattern() {
        return this.isPattern;
    }

    public List<String> getIncludeTypes() {
        return this.includeTypes;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).connectionKey(this.connectionKey).schemaResourceName(this.schemaResourceName).name(this.name).page(this.page).type(this.type).limit(this.limit).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).nameList(this.nameList).isPattern(this.isPattern).includeTypes(this.includeTypes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",schemaResourceName=").append(String.valueOf(this.schemaResourceName));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",nameList=").append(String.valueOf(this.nameList));
        sb.append(",isPattern=").append(String.valueOf(this.isPattern));
        sb.append(",includeTypes=").append(String.valueOf(this.includeTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDataEntitiesRequest)) {
            return false;
        }
        ListDataEntitiesRequest other = (ListDataEntitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.schemaResourceName, other.schemaResourceName) && Objects.equals(this.name, other.name) && Objects.equals(this.page, other.page) && Objects.equals(this.type, other.type) && Objects.equals(this.limit, other.limit) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.nameList, other.nameList) && Objects.equals(this.isPattern, other.isPattern) && Objects.equals(this.includeTypes, other.includeTypes);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.schemaResourceName == null ? 43 : this.schemaResourceName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.nameList == null ? 43 : this.nameList.hashCode());
        result = result * 59 + (this.isPattern == null ? 43 : this.isPattern.hashCode());
        result = result * 59 + (this.includeTypes == null ? 43 : this.includeTypes.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataEntitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String connectionKey = null;
        private String schemaResourceName = null;
        private String name = null;
        private String page = null;
        private String type = null;
        private Integer limit = null;
        private List<String> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;
        private List<String> nameList = null;
        private Boolean isPattern = null;
        private List<String> includeTypes = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nameList(List<String> nameList) {
            this.nameList = nameList;
            return this;
        }

        public Builder nameList(String singularValue) {
            return this.nameList(Arrays.asList(singularValue));
        }

        public Builder isPattern(Boolean isPattern) {
            this.isPattern = isPattern;
            return this;
        }

        public Builder includeTypes(List<String> includeTypes) {
            this.includeTypes = includeTypes;
            return this;
        }

        public Builder includeTypes(String singularValue) {
            return this.includeTypes(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataEntitiesRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.name(o.getName());
            this.page(o.getPage());
            this.type(o.getType());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.nameList(o.getNameList());
            this.isPattern(o.getIsPattern());
            this.includeTypes(o.getIncludeTypes());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataEntitiesRequest build() {
            ListDataEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDataEntitiesRequest buildWithoutInvocationCallback() {
            ListDataEntitiesRequest request = new ListDataEntitiesRequest();
            request.workspaceId = this.workspaceId;
            request.connectionKey = this.connectionKey;
            request.schemaResourceName = this.schemaResourceName;
            request.name = this.name;
            request.page = this.page;
            request.type = this.type;
            request.limit = this.limit;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.nameList = this.nameList;
            request.isPattern = this.isPattern;
            request.includeTypes = this.includeTypes;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME"),
        TimeUpdated("TIME_UPDATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

