/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateEntityShapeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateEntityShapeRequest
extends BmcRequest<CreateEntityShapeDetails> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private CreateEntityShapeDetails createEntityShapeDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public CreateEntityShapeDetails getCreateEntityShapeDetails() {
        return this.createEntityShapeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public CreateEntityShapeDetails getBody$() {
        return this.createEntityShapeDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).connectionKey(this.connectionKey).schemaResourceName(this.schemaResourceName).createEntityShapeDetails(this.createEntityShapeDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",schemaResourceName=").append(String.valueOf(this.schemaResourceName));
        sb.append(",createEntityShapeDetails=").append(String.valueOf((Object)this.createEntityShapeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateEntityShapeRequest)) {
            return false;
        }
        CreateEntityShapeRequest other = (CreateEntityShapeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.schemaResourceName, other.schemaResourceName) && Objects.equals((Object)this.createEntityShapeDetails, (Object)other.createEntityShapeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.schemaResourceName == null ? 43 : this.schemaResourceName.hashCode());
        result = result * 59 + (this.createEntityShapeDetails == null ? 43 : this.createEntityShapeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateEntityShapeRequest, CreateEntityShapeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String connectionKey = null;
        private String schemaResourceName = null;
        private CreateEntityShapeDetails createEntityShapeDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder createEntityShapeDetails(CreateEntityShapeDetails createEntityShapeDetails) {
            this.createEntityShapeDetails = createEntityShapeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateEntityShapeRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.createEntityShapeDetails(o.getCreateEntityShapeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateEntityShapeRequest build() {
            CreateEntityShapeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateEntityShapeDetails body) {
            this.createEntityShapeDetails(body);
            return this;
        }

        public CreateEntityShapeRequest buildWithoutInvocationCallback() {
            CreateEntityShapeRequest request = new CreateEntityShapeRequest();
            request.workspaceId = this.workspaceId;
            request.connectionKey = this.connectionKey;
            request.schemaResourceName = this.schemaResourceName;
            request.createEntityShapeDetails = this.createEntityShapeDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

