/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.AbstractField;
import com.oracle.bmc.dataintegration.model.ConditionalOutputPort;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DecisionOutputPort;
import com.oracle.bmc.dataintegration.model.DerivedField;
import com.oracle.bmc.dataintegration.model.DynamicInputField;
import com.oracle.bmc.dataintegration.model.DynamicProxyField;
import com.oracle.bmc.dataintegration.model.FlowPort;
import com.oracle.bmc.dataintegration.model.InputField;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.InputProxyField;
import com.oracle.bmc.dataintegration.model.MacroField;
import com.oracle.bmc.dataintegration.model.MaterializedDynamicField;
import com.oracle.bmc.dataintegration.model.OutputField;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.PivotField;
import com.oracle.bmc.dataintegration.model.ProxyField;
import com.oracle.bmc.dataintegration.model.Shape;
import com.oracle.bmc.dataintegration.model.ShapeField;
import com.oracle.bmc.dataintegration.model.TypedExpression;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=TypedObject.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OutputPort.class, name="OUTPUT_PORT"), @JsonSubTypes.Type(value=DynamicInputField.class, name="DYNAMIC_INPUT_FIELD"), @JsonSubTypes.Type(value=AbstractField.class, name="FIELD"), @JsonSubTypes.Type(value=InputField.class, name="INPUT_FIELD"), @JsonSubTypes.Type(value=Shape.class, name="SHAPE"), @JsonSubTypes.Type(value=InputPort.class, name="INPUT_PORT"), @JsonSubTypes.Type(value=ConditionalOutputPort.class, name="CONDITIONAL_OUTPUT_PORT"), @JsonSubTypes.Type(value=DecisionOutputPort.class, name="DECISION_OUTPUT_PORT"), @JsonSubTypes.Type(value=MaterializedDynamicField.class, name="MATERIALIZED_DYNAMIC_FIELD"), @JsonSubTypes.Type(value=ProxyField.class, name="PROXY_FIELD"), @JsonSubTypes.Type(value=DynamicProxyField.class, name="DYNAMIC_PROXY_FIELD"), @JsonSubTypes.Type(value=ShapeField.class, name="SHAPE_FIELD"), @JsonSubTypes.Type(value=InputProxyField.class, name="INPUT_PROXY_FIELD"), @JsonSubTypes.Type(value=Parameter.class, name="PARAMETER"), @JsonSubTypes.Type(value=PivotField.class, name="PIVOT_FIELD"), @JsonSubTypes.Type(value=OutputField.class, name="OUTPUT_FIELD"), @JsonSubTypes.Type(value=MacroField.class, name="MACRO_FIELD"), @JsonSubTypes.Type(value=DerivedField.class, name="DERIVED_FIELD"), @JsonSubTypes.Type(value=TypedExpression.class, name="TYPED_EXPRESSION"), @JsonSubTypes.Type(value=FlowPort.class, name="FLOW_PORT")})
@JsonFilter(value="explicitlySetFilter")
public class TypedObject
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "configValues", "objectStatus", "name", "description"})
    protected TypedObject(String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, Integer objectStatus, String name, String description) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.configValues = configValues;
        this.objectStatus = objectStatus;
        this.name = name;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TypedObject(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedObject)) {
            return false;
        }
        TypedObject other = (TypedObject)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        Shape("SHAPE"),
        InputPort("INPUT_PORT"),
        ShapeField("SHAPE_FIELD"),
        InputField("INPUT_FIELD"),
        DerivedField("DERIVED_FIELD"),
        MacroField("MACRO_FIELD"),
        OutputField("OUTPUT_FIELD"),
        DynamicProxyField("DYNAMIC_PROXY_FIELD"),
        OutputPort("OUTPUT_PORT"),
        DynamicInputField("DYNAMIC_INPUT_FIELD"),
        ProxyField("PROXY_FIELD"),
        Parameter("PARAMETER"),
        PivotField("PIVOT_FIELD"),
        MacroPivotField("MACRO_PIVOT_FIELD"),
        ConditionalOutputPort("CONDITIONAL_OUTPUT_PORT"),
        InputProxyField("INPUT_PROXY_FIELD"),
        MaterializedDynamicField("MATERIALIZED_DYNAMIC_FIELD"),
        DecisionOutputPort("DECISION_OUTPUT_PORT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

