/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFrequencyDetails;
import com.oracle.bmc.dataintegration.model.Time;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class MonthlyRuleFrequencyDetails
extends AbstractFrequencyDetails {
    @JsonProperty(value="weekOfMonth")
    private final WeekOfMonth weekOfMonth;
    @JsonProperty(value="interval")
    private final Integer interval;
    @JsonProperty(value="time")
    private final Time time;
    @JsonProperty(value="dayOfWeek")
    private final DayOfWeek dayOfWeek;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MonthlyRuleFrequencyDetails(AbstractFrequencyDetails.Frequency frequency, WeekOfMonth weekOfMonth, Integer interval, Time time, DayOfWeek dayOfWeek) {
        super(frequency);
        this.weekOfMonth = weekOfMonth;
        this.interval = interval;
        this.time = time;
        this.dayOfWeek = dayOfWeek;
    }

    public WeekOfMonth getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Time getTime() {
        return this.time;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonthlyRuleFrequencyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", weekOfMonth=").append(String.valueOf((Object)this.weekOfMonth));
        sb.append(", interval=").append(String.valueOf(this.interval));
        sb.append(", time=").append(String.valueOf((Object)this.time));
        sb.append(", dayOfWeek=").append(String.valueOf((Object)this.dayOfWeek));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonthlyRuleFrequencyDetails)) {
            return false;
        }
        MonthlyRuleFrequencyDetails other = (MonthlyRuleFrequencyDetails)((Object)o);
        return Objects.equals((Object)this.weekOfMonth, (Object)other.weekOfMonth) && Objects.equals(this.interval, other.interval) && Objects.equals((Object)this.time, (Object)other.time) && Objects.equals((Object)this.dayOfWeek, (Object)other.dayOfWeek) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.weekOfMonth == null ? 43 : this.weekOfMonth.hashCode());
        result = result * 59 + (this.interval == null ? 43 : this.interval.hashCode());
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + (this.dayOfWeek == null ? 43 : this.dayOfWeek.hashCode());
        return result;
    }

    public static enum DayOfWeek implements BmcEnum
    {
        Sunday("SUNDAY"),
        Monday("MONDAY"),
        Tuesday("TUESDAY"),
        Wednesday("WEDNESDAY"),
        Thursday("THURSDAY"),
        Friday("FRIDAY"),
        Saturday("SATURDAY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DayOfWeek> map;

        private DayOfWeek(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DayOfWeek create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DayOfWeek', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DayOfWeek.class);
            map = new HashMap<String, DayOfWeek>();
            for (DayOfWeek v : DayOfWeek.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum WeekOfMonth implements BmcEnum
    {
        First("FIRST"),
        Second("SECOND"),
        Third("THIRD"),
        Fourth("FOURTH"),
        Fifth("FIFTH"),
        Last("LAST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, WeekOfMonth> map;

        private WeekOfMonth(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WeekOfMonth create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'WeekOfMonth', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(WeekOfMonth.class);
            map = new HashMap<String, WeekOfMonth>();
            for (WeekOfMonth v : WeekOfMonth.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="frequency")
        private AbstractFrequencyDetails.Frequency frequency;
        @JsonProperty(value="weekOfMonth")
        private WeekOfMonth weekOfMonth;
        @JsonProperty(value="interval")
        private Integer interval;
        @JsonProperty(value="time")
        private Time time;
        @JsonProperty(value="dayOfWeek")
        private DayOfWeek dayOfWeek;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder frequency(AbstractFrequencyDetails.Frequency frequency) {
            this.frequency = frequency;
            this.__explicitlySet__.add("frequency");
            return this;
        }

        public Builder weekOfMonth(WeekOfMonth weekOfMonth) {
            this.weekOfMonth = weekOfMonth;
            this.__explicitlySet__.add("weekOfMonth");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.__explicitlySet__.add("interval");
            return this;
        }

        public Builder time(Time time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.__explicitlySet__.add("dayOfWeek");
            return this;
        }

        public MonthlyRuleFrequencyDetails build() {
            MonthlyRuleFrequencyDetails model = new MonthlyRuleFrequencyDetails(this.frequency, this.weekOfMonth, this.interval, this.time, this.dayOfWeek);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonthlyRuleFrequencyDetails model) {
            if (model.wasPropertyExplicitlySet("frequency")) {
                this.frequency(model.getFrequency());
            }
            if (model.wasPropertyExplicitlySet("weekOfMonth")) {
                this.weekOfMonth(model.getWeekOfMonth());
            }
            if (model.wasPropertyExplicitlySet("interval")) {
                this.interval(model.getInterval());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            if (model.wasPropertyExplicitlySet("dayOfWeek")) {
                this.dayOfWeek(model.getDayOfWeek());
            }
            return this;
        }
    }
}

