/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionSummaryFromLakehouse;
import com.oracle.bmc.dataintegration.model.DataAssetSummary;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypeSystem;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DataAssetSummaryFromLakehouse
extends DataAssetSummary {
    @JsonProperty(value="lakehouseOcid")
    private final String lakehouseOcid;
    @JsonProperty(value="metastoreId")
    private final String metastoreId;
    @JsonProperty(value="rangerEndpoint")
    private final String rangerEndpoint;
    @JsonProperty(value="defaultConnection")
    private final ConnectionSummaryFromLakehouse defaultConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DataAssetSummaryFromLakehouse(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, TypeSystem nativeTypeSystem, Integer objectVersion, ParentReference parentRef, ObjectMetadata metadata, String lakehouseOcid, String metastoreId, String rangerEndpoint, ConnectionSummaryFromLakehouse defaultConnection) {
        super(key, modelVersion, name, description, objectStatus, identifier, externalKey, assetProperties, nativeTypeSystem, objectVersion, parentRef, metadata);
        this.lakehouseOcid = lakehouseOcid;
        this.metastoreId = metastoreId;
        this.rangerEndpoint = rangerEndpoint;
        this.defaultConnection = defaultConnection;
    }

    public String getLakehouseOcid() {
        return this.lakehouseOcid;
    }

    public String getMetastoreId() {
        return this.metastoreId;
    }

    public String getRangerEndpoint() {
        return this.rangerEndpoint;
    }

    public ConnectionSummaryFromLakehouse getDefaultConnection() {
        return this.defaultConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAssetSummaryFromLakehouse(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", lakehouseOcid=").append(String.valueOf(this.lakehouseOcid));
        sb.append(", metastoreId=").append(String.valueOf(this.metastoreId));
        sb.append(", rangerEndpoint=").append(String.valueOf(this.rangerEndpoint));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAssetSummaryFromLakehouse)) {
            return false;
        }
        DataAssetSummaryFromLakehouse other = (DataAssetSummaryFromLakehouse)((Object)o);
        return Objects.equals(this.lakehouseOcid, other.lakehouseOcid) && Objects.equals(this.metastoreId, other.metastoreId) && Objects.equals(this.rangerEndpoint, other.rangerEndpoint) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.lakehouseOcid == null ? 43 : this.lakehouseOcid.hashCode());
        result = result * 59 + (this.metastoreId == null ? 43 : this.metastoreId.hashCode());
        result = result * 59 + (this.rangerEndpoint == null ? 43 : this.rangerEndpoint.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="nativeTypeSystem")
        private TypeSystem nativeTypeSystem;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="lakehouseOcid")
        private String lakehouseOcid;
        @JsonProperty(value="metastoreId")
        private String metastoreId;
        @JsonProperty(value="rangerEndpoint")
        private String rangerEndpoint;
        @JsonProperty(value="defaultConnection")
        private ConnectionSummaryFromLakehouse defaultConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder nativeTypeSystem(TypeSystem nativeTypeSystem) {
            this.nativeTypeSystem = nativeTypeSystem;
            this.__explicitlySet__.add("nativeTypeSystem");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder lakehouseOcid(String lakehouseOcid) {
            this.lakehouseOcid = lakehouseOcid;
            this.__explicitlySet__.add("lakehouseOcid");
            return this;
        }

        public Builder metastoreId(String metastoreId) {
            this.metastoreId = metastoreId;
            this.__explicitlySet__.add("metastoreId");
            return this;
        }

        public Builder rangerEndpoint(String rangerEndpoint) {
            this.rangerEndpoint = rangerEndpoint;
            this.__explicitlySet__.add("rangerEndpoint");
            return this;
        }

        public Builder defaultConnection(ConnectionSummaryFromLakehouse defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public DataAssetSummaryFromLakehouse build() {
            DataAssetSummaryFromLakehouse model = new DataAssetSummaryFromLakehouse(this.key, this.modelVersion, this.name, this.description, this.objectStatus, this.identifier, this.externalKey, this.assetProperties, this.nativeTypeSystem, this.objectVersion, this.parentRef, this.metadata, this.lakehouseOcid, this.metastoreId, this.rangerEndpoint, this.defaultConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataAssetSummaryFromLakehouse model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("nativeTypeSystem")) {
                this.nativeTypeSystem(model.getNativeTypeSystem());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("lakehouseOcid")) {
                this.lakehouseOcid(model.getLakehouseOcid());
            }
            if (model.wasPropertyExplicitlySet("metastoreId")) {
                this.metastoreId(model.getMetastoreId());
            }
            if (model.wasPropertyExplicitlySet("rangerEndpoint")) {
                this.rangerEndpoint(model.getRangerEndpoint());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            return this;
        }
    }
}

