/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionDetails;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionFromRestBasicAuthDetails
extends ConnectionDetails {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="passwordSecret")
    private final SensitiveAttribute passwordSecret;
    @JsonProperty(value="authHeader")
    private final String authHeader;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConnectionFromRestBasicAuthDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, String username, SensitiveAttribute passwordSecret, String authHeader) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, primarySchema, connectionProperties, isDefault, metadata);
        this.username = username;
        this.passwordSecret = passwordSecret;
        this.authHeader = authHeader;
    }

    public String getUsername() {
        return this.username;
    }

    public SensitiveAttribute getPasswordSecret() {
        return this.passwordSecret;
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionFromRestBasicAuthDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", passwordSecret=").append(String.valueOf((Object)this.passwordSecret));
        sb.append(", authHeader=").append(String.valueOf(this.authHeader));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionFromRestBasicAuthDetails)) {
            return false;
        }
        ConnectionFromRestBasicAuthDetails other = (ConnectionFromRestBasicAuthDetails)((Object)o);
        return Objects.equals(this.username, other.username) && Objects.equals((Object)this.passwordSecret, (Object)other.passwordSecret) && Objects.equals(this.authHeader, other.authHeader) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.passwordSecret == null ? 43 : this.passwordSecret.hashCode());
        result = result * 59 + (this.authHeader == null ? 43 : this.authHeader.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="primarySchema")
        private Schema primarySchema;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="passwordSecret")
        private SensitiveAttribute passwordSecret;
        @JsonProperty(value="authHeader")
        private String authHeader;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder primarySchema(Schema primarySchema) {
            this.primarySchema = primarySchema;
            this.__explicitlySet__.add("primarySchema");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder passwordSecret(SensitiveAttribute passwordSecret) {
            this.passwordSecret = passwordSecret;
            this.__explicitlySet__.add("passwordSecret");
            return this;
        }

        public Builder authHeader(String authHeader) {
            this.authHeader = authHeader;
            this.__explicitlySet__.add("authHeader");
            return this;
        }

        public ConnectionFromRestBasicAuthDetails build() {
            ConnectionFromRestBasicAuthDetails model = new ConnectionFromRestBasicAuthDetails(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.primarySchema, this.connectionProperties, this.isDefault, this.metadata, this.username, this.passwordSecret, this.authHeader);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionFromRestBasicAuthDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("primarySchema")) {
                this.primarySchema(model.getPrimarySchema());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("passwordSecret")) {
                this.passwordSecret(model.getPasswordSecret());
            }
            if (model.wasPropertyExplicitlySet("authHeader")) {
                this.authHeader(model.getAuthHeader());
            }
            return this;
        }
    }
}

