/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="resourceUri")
    private final String resourceUri;
    @JsonProperty(value="workRequestid")
    private final String workRequestid;

    @Deprecated
    @ConstructorProperties(value={"actionType", "id", "resourceId", "resourceType", "resourceUri", "workRequestid"})
    public WorkRequestResource(ActionType actionType, Long id, String resourceId, String resourceType, String resourceUri, String workRequestid) {
        this.actionType = actionType;
        this.id = id;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.resourceUri = resourceUri;
        this.workRequestid = workRequestid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public Long getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getWorkRequestid() {
        return this.workRequestid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("super=").append(super.toString());
        sb.append("actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", resourceUri=").append(String.valueOf(this.resourceUri));
        sb.append(", workRequestid=").append(String.valueOf(this.workRequestid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)((Object)o);
        return Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.id, other.id) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.resourceUri, other.resourceUri) && Objects.equals(this.workRequestid, other.workRequestid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceUri == null ? 43 : this.resourceUri.hashCode());
        result = result * 59 + (this.workRequestid == null ? 43 : this.workRequestid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActionType implements BmcEnum
    {
        Created("CREATED"),
        Updated("UPDATED"),
        Deleted("DELETED"),
        Inprogress("INPROGRESS"),
        Related("RELATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="resourceUri")
        private String resourceUri;
        @JsonProperty(value="workRequestid")
        private String workRequestid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            this.__explicitlySet__.add("resourceUri");
            return this;
        }

        public Builder workRequestid(String workRequestid) {
            this.workRequestid = workRequestid;
            this.__explicitlySet__.add("workRequestid");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource model = new WorkRequestResource(this.actionType, this.id, this.resourceId, this.resourceType, this.resourceUri, this.workRequestid);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource model) {
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceUri")) {
                this.resourceUri(model.getResourceUri());
            }
            if (model.wasPropertyExplicitlySet("workRequestid")) {
                this.workRequestid(model.getWorkRequestid());
            }
            return this;
        }
    }
}

