/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataflow.DataFlowAsync;
import com.oracle.bmc.dataflow.model.Application;
import com.oracle.bmc.dataflow.model.ApplicationSummary;
import com.oracle.bmc.dataflow.model.PrivateEndpoint;
import com.oracle.bmc.dataflow.model.PrivateEndpointCollection;
import com.oracle.bmc.dataflow.model.Run;
import com.oracle.bmc.dataflow.model.RunLogSummary;
import com.oracle.bmc.dataflow.model.RunSummary;
import com.oracle.bmc.dataflow.model.Statement;
import com.oracle.bmc.dataflow.model.StatementCollection;
import com.oracle.bmc.dataflow.model.WorkRequest;
import com.oracle.bmc.dataflow.model.WorkRequestCollection;
import com.oracle.bmc.dataflow.model.WorkRequestErrorCollection;
import com.oracle.bmc.dataflow.model.WorkRequestLogCollection;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.CreateStatementRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteStatementRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetStatementRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListStatementsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.CreateStatementResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteStatementResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetStatementResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListStatementsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlowAsyncClient
extends BaseAsyncClient
implements DataFlowAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAFLOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataflow.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataFlowAsyncClient.class);

    private DataFlowAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request, AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApplicationCompartmentDetails(), "changeApplicationCompartmentDetails is required");
        return this.clientCall(request, ChangeApplicationCompartmentResponse::builder).logger(LOG, "changeApplicationCompartment").serviceDetails("DataFlow", "ChangeApplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/ChangeApplicationCompartment").method(Method.POST).requestBuilder(ChangeApplicationCompartmentRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeApplicationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangePrivateEndpointCompartmentResponse> changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request, AsyncHandler<ChangePrivateEndpointCompartmentRequest, ChangePrivateEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateEndpointCompartmentDetails(), "changePrivateEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangePrivateEndpointCompartmentResponse::builder).logger(LOG, "changePrivateEndpointCompartment").serviceDetails("DataFlow", "ChangePrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/ChangePrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangePrivateEndpointCompartmentRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeRunCompartmentResponse> changeRunCompartment(ChangeRunCompartmentRequest request, AsyncHandler<ChangeRunCompartmentRequest, ChangeRunCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRunCompartmentDetails(), "changeRunCompartmentDetails is required");
        return this.clientCall(request, ChangeRunCompartmentResponse::builder).logger(LOG, "changeRunCompartment").serviceDetails("DataFlow", "ChangeRunCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/ChangeRunCompartment").method(Method.POST).requestBuilder(ChangeRunCompartmentRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRunCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        Objects.requireNonNull(request.getCreateApplicationDetails(), "createApplicationDetails is required");
        return this.clientCall(request, CreateApplicationResponse::builder).logger(LOG, "createApplication").serviceDetails("DataFlow", "CreateApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/CreateApplication").method(Method.POST).requestBuilder(CreateApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Application.class, CreateApplicationResponse.Builder::application).handleResponseHeaderString("etag", CreateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request, AsyncHandler<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreatePrivateEndpointDetails(), "createPrivateEndpointDetails is required");
        return this.clientCall(request, CreatePrivateEndpointResponse::builder).logger(LOG, "createPrivateEndpoint").serviceDetails("DataFlow", "CreatePrivateEndpoint", "").method(Method.POST).requestBuilder(CreatePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PrivateEndpoint.class, CreatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("etag", CreatePrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreatePrivateEndpointResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateRunResponse> createRun(CreateRunRequest request, AsyncHandler<CreateRunRequest, CreateRunResponse> handler) {
        Objects.requireNonNull(request.getCreateRunDetails(), "createRunDetails is required");
        return this.clientCall(request, CreateRunResponse::builder).logger(LOG, "createRun").serviceDetails("DataFlow", "CreateRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/CreateRun").method(Method.POST).requestBuilder(CreateRunRequest::builder).basePath("/20200129").appendPathParam("runs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Run.class, CreateRunResponse.Builder::run).handleResponseHeaderString("etag", CreateRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateStatementResponse> createStatement(CreateStatementRequest request, AsyncHandler<CreateStatementRequest, CreateStatementResponse> handler) {
        Objects.requireNonNull(request.getCreateStatementDetails(), "createStatementDetails is required");
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateStatementResponse::builder).logger(LOG, "createStatement").serviceDetails("DataFlow", "CreateStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/CreateStatement").method(Method.POST).requestBuilder(CreateStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Statement.class, CreateStatementResponse.Builder::statement).handleResponseHeaderString("etag", CreateStatementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateStatementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApplicationResponse::builder).logger(LOG, "deleteApplication").serviceDetails("DataFlow", "DeleteApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/DeleteApplication").method(Method.DELETE).requestBuilder(DeleteApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request, AsyncHandler<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePrivateEndpointResponse::builder).logger(LOG, "deletePrivateEndpoint").serviceDetails("DataFlow", "DeletePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/DeletePrivateEndpoint").method(Method.DELETE).requestBuilder(DeletePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeletePrivateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRunResponse> deleteRun(DeleteRunRequest request, AsyncHandler<DeleteRunRequest, DeleteRunResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRunResponse::builder).logger(LOG, "deleteRun").serviceDetails("DataFlow", "DeleteRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/DeleteRun").method(Method.DELETE).requestBuilder(DeleteRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteStatementResponse> deleteStatement(DeleteStatementRequest request, AsyncHandler<DeleteStatementRequest, DeleteStatementResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStatementId(), (String)"statementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteStatementResponse::builder).logger(LOG, "deleteStatement").serviceDetails("DataFlow", "DeleteStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/DeleteStatement").method(Method.DELETE).requestBuilder(DeleteStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendPathParam(request.getStatementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStatementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApplicationResponse::builder).logger(LOG, "getApplication").serviceDetails("DataFlow", "GetApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/GetApplication").method(Method.GET).requestBuilder(GetApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Application.class, GetApplicationResponse.Builder::application).handleResponseHeaderString("etag", GetApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request, AsyncHandler<GetPrivateEndpointRequest, GetPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateEndpointResponse::builder).logger(LOG, "getPrivateEndpoint").serviceDetails("DataFlow", "GetPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/GetPrivateEndpoint").method(Method.GET).requestBuilder(GetPrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpoint.class, GetPrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("etag", GetPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRunResponse> getRun(GetRunRequest request, AsyncHandler<GetRunRequest, GetRunResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRunResponse::builder).logger(LOG, "getRun").serviceDetails("DataFlow", "GetRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/GetRun").method(Method.GET).requestBuilder(GetRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Run.class, GetRunResponse.Builder::run).handleResponseHeaderString("etag", GetRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRunLogResponse> getRunLog(GetRunLogRequest request, AsyncHandler<GetRunLogRequest, GetRunLogResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRunLogResponse::builder).logger(LOG, "getRunLog").serviceDetails("DataFlow", "GetRunLog", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/GetRunLog").method(Method.GET).requestBuilder(GetRunLogRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("logs").appendPathParam(request.getName()).accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetRunLogResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetRunLogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRunLogResponse.Builder::etag).handleResponseHeaderLong("content-length", GetRunLogResponse.Builder::contentLength).handleResponseHeaderString("content-type", GetRunLogResponse.Builder::contentType).handleResponseHeaderString("content-encoding", GetRunLogResponse.Builder::contentEncoding).handleResponseHeadersMap("opc-meta-", GetRunLogResponse.Builder::opcMeta).callAsync(handler);
    }

    @Override
    public Future<GetStatementResponse> getStatement(GetStatementRequest request, AsyncHandler<GetStatementRequest, GetStatementResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStatementId(), (String)"statementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetStatementResponse::builder).logger(LOG, "getStatement").serviceDetails("DataFlow", "GetStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/GetStatement").method(Method.GET).requestBuilder(GetStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendPathParam(request.getStatementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Statement.class, GetStatementResponse.Builder::statement).handleResponseHeaderString("etag", GetStatementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetStatementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataFlow", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApplicationsResponse::builder).logger(LOG, "listApplications").serviceDetails("DataFlow", "ListApplications", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/ApplicationSummary/ListApplications").method(Method.GET).requestBuilder(ListApplicationsRequest::builder).basePath("/20200129").appendPathParam("applications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).appendQueryParam("sparkVersion", (Object)request.getSparkVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApplicationSummary.class, ListApplicationsResponse.Builder::items).handleResponseHeaderString("opc-prev-page", ListApplicationsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListApplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListApplicationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request, AsyncHandler<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPrivateEndpointsResponse::builder).logger(LOG, "listPrivateEndpoints").serviceDetails("DataFlow", "ListPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/ListPrivateEndpoints").method(Method.GET).requestBuilder(ListPrivateEndpointsRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateEndpointCollection.class, ListPrivateEndpointsResponse.Builder::privateEndpointCollection).handleResponseHeaderString("opc-prev-page", ListPrivateEndpointsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListPrivateEndpointsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPrivateEndpointsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRunLogsResponse> listRunLogs(ListRunLogsRequest request, AsyncHandler<ListRunLogsRequest, ListRunLogsResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRunLogsResponse::builder).logger(LOG, "listRunLogs").serviceDetails("DataFlow", "ListRunLogs", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/RunLogSummary/ListRunLogs").method(Method.GET).requestBuilder(ListRunLogsRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(RunLogSummary.class, ListRunLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRunLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListRunLogsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListRunLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRunsResponse> listRuns(ListRunsRequest request, AsyncHandler<ListRunsRequest, ListRunsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRunsResponse::builder).logger(LOG, "listRuns").serviceDetails("DataFlow", "ListRuns", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/RunSummary/ListRuns").method(Method.GET).requestBuilder(ListRunsRequest::builder).basePath("/20200129").appendPathParam("runs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreatedGreaterThan", (Object)request.getTimeCreatedGreaterThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(RunSummary.class, ListRunsResponse.Builder::items).handleResponseHeaderString("opc-prev-page", ListRunsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListRunsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRunsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListStatementsResponse> listStatements(ListStatementsRequest request, AsyncHandler<ListStatementsRequest, ListStatementsResponse> handler) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListStatementsResponse::builder).logger(LOG, "listStatements").serviceDetails("DataFlow", "ListStatements", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/StatementCollection/ListStatements").method(Method.GET).requestBuilder(ListStatementsRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StatementCollection.class, ListStatementsResponse.Builder::statementCollection).handleResponseHeaderString("opc-prev-page", ListStatementsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListStatementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListStatementsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataFlow", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestErrorsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataFlow", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestLogsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataFlow", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        Objects.requireNonNull(request.getUpdateApplicationDetails(), "updateApplicationDetails is required");
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateApplicationResponse::builder).logger(LOG, "updateApplication").serviceDetails("DataFlow", "UpdateApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/UpdateApplication").method(Method.PUT).requestBuilder(UpdateApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Application.class, UpdateApplicationResponse.Builder::application).handleResponseHeaderString("etag", UpdateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request, AsyncHandler<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getUpdatePrivateEndpointDetails(), "updatePrivateEndpointDetails is required");
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdatePrivateEndpointResponse::builder).logger(LOG, "updatePrivateEndpoint").serviceDetails("DataFlow", "UpdatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/UpdatePrivateEndpoint").method(Method.PUT).requestBuilder(UpdatePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePrivateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRunResponse> updateRun(UpdateRunRequest request, AsyncHandler<UpdateRunRequest, UpdateRunResponse> handler) {
        Objects.requireNonNull(request.getUpdateRunDetails(), "updateRunDetails is required");
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateRunResponse::builder).logger(LOG, "updateRun").serviceDetails("DataFlow", "UpdateRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/UpdateRun").method(Method.PUT).requestBuilder(UpdateRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Run.class, UpdateRunResponse.Builder::run).handleResponseHeaderString("etag", UpdateRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataFlowAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataFlowAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataFlowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataFlowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataFlowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataFlowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataFlowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataFlowAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataFlowAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataFlowAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

