/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.UpdateDataAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDataAssetRequest
extends BmcRequest<UpdateDataAssetDetails> {
    private String registryId;
    private String dataAssetKey;
    private UpdateDataAssetDetails updateDataAssetDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public UpdateDataAssetDetails getUpdateDataAssetDetails() {
        return this.updateDataAssetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDataAssetDetails getBody$() {
        return this.updateDataAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).dataAssetKey(this.dataAssetKey).updateDataAssetDetails(this.updateDataAssetDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",updateDataAssetDetails=").append(String.valueOf((Object)this.updateDataAssetDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataAssetRequest)) {
            return false;
        }
        UpdateDataAssetRequest other = (UpdateDataAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals((Object)this.updateDataAssetDetails, (Object)other.updateDataAssetDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.updateDataAssetDetails == null ? 43 : this.updateDataAssetDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDataAssetRequest, UpdateDataAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String dataAssetKey = null;
        private UpdateDataAssetDetails updateDataAssetDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder updateDataAssetDetails(UpdateDataAssetDetails updateDataAssetDetails) {
            this.updateDataAssetDetails = updateDataAssetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDataAssetRequest o) {
            this.registryId(o.getRegistryId());
            this.dataAssetKey(o.getDataAssetKey());
            this.updateDataAssetDetails(o.getUpdateDataAssetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDataAssetRequest build() {
            UpdateDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDataAssetDetails body) {
            this.updateDataAssetDetails(body);
            return this;
        }

        public UpdateDataAssetRequest buildWithoutInvocationCallback() {
            UpdateDataAssetRequest request = new UpdateDataAssetRequest();
            request.registryId = this.registryId;
            request.dataAssetKey = this.dataAssetKey;
            request.updateDataAssetDetails = this.updateDataAssetDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

