/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListFoldersRequest
extends BmcRequest<Void> {
    private String registryId;
    private String name;
    private String page;
    private Integer limit;
    private List<String> fields;
    private String type;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private FavoritesQueryParam favoritesQueryParam;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getType() {
        return this.type;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public FavoritesQueryParam getFavoritesQueryParam() {
        return this.favoritesQueryParam;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).name(this.name).page(this.page).limit(this.limit).fields(this.fields).type(this.type).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).favoritesQueryParam(this.favoritesQueryParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",favoritesQueryParam=").append(String.valueOf((Object)this.favoritesQueryParam));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListFoldersRequest)) {
            return false;
        }
        ListFoldersRequest other = (ListFoldersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.name, other.name) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.fields, other.fields) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.favoritesQueryParam, (Object)other.favoritesQueryParam);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.favoritesQueryParam == null ? 43 : this.favoritesQueryParam.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFoldersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String name = null;
        private String page = null;
        private Integer limit = null;
        private List<String> fields = null;
        private String type = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;
        private FavoritesQueryParam favoritesQueryParam = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder favoritesQueryParam(FavoritesQueryParam favoritesQueryParam) {
            this.favoritesQueryParam = favoritesQueryParam;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFoldersRequest o) {
            this.registryId(o.getRegistryId());
            this.name(o.getName());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.type(o.getType());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.favoritesQueryParam(o.getFavoritesQueryParam());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFoldersRequest build() {
            ListFoldersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListFoldersRequest buildWithoutInvocationCallback() {
            ListFoldersRequest request = new ListFoldersRequest();
            request.registryId = this.registryId;
            request.name = this.name;
            request.page = this.page;
            request.limit = this.limit;
            request.fields = this.fields;
            request.type = this.type;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.favoritesQueryParam = this.favoritesQueryParam;
            return request;
        }
    }

    public static enum FavoritesQueryParam implements BmcEnum
    {
        FavoritesOnly("FAVORITES_ONLY"),
        NonFavoritesOnly("NON_FAVORITES_ONLY"),
        All("ALL");

        private final String value;
        private static Map<String, FavoritesQueryParam> map;

        private FavoritesQueryParam(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FavoritesQueryParam create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FavoritesQueryParam: " + key);
        }

        static {
            map = new HashMap<String, FavoritesQueryParam>();
            for (FavoritesQueryParam v : FavoritesQueryParam.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Id("id"),
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

