/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDataAssetsRequest
extends BmcRequest<Void> {
    private String registryId;
    private String page;
    private Integer limit;
    private List<String> fields;
    private List<String> includeTypes;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String name;
    private String opcRequestId;
    private List<String> excludeTypes;
    private FavoritesQueryParam favoritesQueryParam;
    private String folderId;
    private List<String> endpointIds;
    private List<String> excludeEndpointIds;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getIncludeTypes() {
        return this.includeTypes;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getExcludeTypes() {
        return this.excludeTypes;
    }

    public FavoritesQueryParam getFavoritesQueryParam() {
        return this.favoritesQueryParam;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public List<String> getEndpointIds() {
        return this.endpointIds;
    }

    public List<String> getExcludeEndpointIds() {
        return this.excludeEndpointIds;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).page(this.page).limit(this.limit).fields(this.fields).includeTypes(this.includeTypes).sortBy(this.sortBy).sortOrder(this.sortOrder).name(this.name).opcRequestId(this.opcRequestId).excludeTypes(this.excludeTypes).favoritesQueryParam(this.favoritesQueryParam).folderId(this.folderId).endpointIds(this.endpointIds).excludeEndpointIds(this.excludeEndpointIds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",includeTypes=").append(String.valueOf(this.includeTypes));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",excludeTypes=").append(String.valueOf(this.excludeTypes));
        sb.append(",favoritesQueryParam=").append(String.valueOf((Object)this.favoritesQueryParam));
        sb.append(",folderId=").append(String.valueOf(this.folderId));
        sb.append(",endpointIds=").append(String.valueOf(this.endpointIds));
        sb.append(",excludeEndpointIds=").append(String.valueOf(this.excludeEndpointIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDataAssetsRequest)) {
            return false;
        }
        ListDataAssetsRequest other = (ListDataAssetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.fields, other.fields) && Objects.equals(this.includeTypes, other.includeTypes) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.name, other.name) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.excludeTypes, other.excludeTypes) && Objects.equals((Object)this.favoritesQueryParam, (Object)other.favoritesQueryParam) && Objects.equals(this.folderId, other.folderId) && Objects.equals(this.endpointIds, other.endpointIds) && Objects.equals(this.excludeEndpointIds, other.excludeEndpointIds);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.includeTypes == null ? 43 : this.includeTypes.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.excludeTypes == null ? 43 : this.excludeTypes.hashCode());
        result = result * 59 + (this.favoritesQueryParam == null ? 43 : this.favoritesQueryParam.hashCode());
        result = result * 59 + (this.folderId == null ? 43 : this.folderId.hashCode());
        result = result * 59 + (this.endpointIds == null ? 43 : this.endpointIds.hashCode());
        result = result * 59 + (this.excludeEndpointIds == null ? 43 : this.excludeEndpointIds.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataAssetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String page = null;
        private Integer limit = null;
        private List<String> fields = null;
        private List<String> includeTypes = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String name = null;
        private String opcRequestId = null;
        private List<String> excludeTypes = null;
        private FavoritesQueryParam favoritesQueryParam = null;
        private String folderId = null;
        private List<String> endpointIds = null;
        private List<String> excludeEndpointIds = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder includeTypes(List<String> includeTypes) {
            this.includeTypes = includeTypes;
            return this;
        }

        public Builder includeTypes(String singularValue) {
            return this.includeTypes(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder excludeTypes(List<String> excludeTypes) {
            this.excludeTypes = excludeTypes;
            return this;
        }

        public Builder excludeTypes(String singularValue) {
            return this.excludeTypes(Arrays.asList(singularValue));
        }

        public Builder favoritesQueryParam(FavoritesQueryParam favoritesQueryParam) {
            this.favoritesQueryParam = favoritesQueryParam;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder endpointIds(List<String> endpointIds) {
            this.endpointIds = endpointIds;
            return this;
        }

        public Builder endpointIds(String singularValue) {
            return this.endpointIds(Arrays.asList(singularValue));
        }

        public Builder excludeEndpointIds(List<String> excludeEndpointIds) {
            this.excludeEndpointIds = excludeEndpointIds;
            return this;
        }

        public Builder excludeEndpointIds(String singularValue) {
            return this.excludeEndpointIds(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataAssetsRequest o) {
            this.registryId(o.getRegistryId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.includeTypes(o.getIncludeTypes());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.excludeTypes(o.getExcludeTypes());
            this.favoritesQueryParam(o.getFavoritesQueryParam());
            this.folderId(o.getFolderId());
            this.endpointIds(o.getEndpointIds());
            this.excludeEndpointIds(o.getExcludeEndpointIds());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataAssetsRequest build() {
            ListDataAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDataAssetsRequest buildWithoutInvocationCallback() {
            ListDataAssetsRequest request = new ListDataAssetsRequest();
            request.registryId = this.registryId;
            request.page = this.page;
            request.limit = this.limit;
            request.fields = this.fields;
            request.includeTypes = this.includeTypes;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.name = this.name;
            request.opcRequestId = this.opcRequestId;
            request.excludeTypes = this.excludeTypes;
            request.favoritesQueryParam = this.favoritesQueryParam;
            request.folderId = this.folderId;
            request.endpointIds = this.endpointIds;
            request.excludeEndpointIds = this.excludeEndpointIds;
            return request;
        }
    }

    public static enum FavoritesQueryParam implements BmcEnum
    {
        FavoritesOnly("FAVORITES_ONLY"),
        NonFavoritesOnly("NON_FAVORITES_ONLY"),
        All("ALL");

        private final String value;
        private static Map<String, FavoritesQueryParam> map;

        private FavoritesQueryParam(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FavoritesQueryParam create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FavoritesQueryParam: " + key);
        }

        static {
            map = new HashMap<String, FavoritesQueryParam>();
            for (FavoritesQueryParam v : FavoritesQueryParam.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Id("id"),
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

