/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetTypeRequest
extends BmcRequest<Void> {
    private String registryId;
    private String typeKey;
    private String opcRequestId;
    private List<String> fields;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).typeKey(this.typeKey).opcRequestId(this.opcRequestId).fields(this.fields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",typeKey=").append(String.valueOf(this.typeKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTypeRequest)) {
            return false;
        }
        GetTypeRequest other = (GetTypeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.typeKey, other.typeKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.fields, other.fields);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.typeKey == null ? 43 : this.typeKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTypeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String typeKey = null;
        private String opcRequestId = null;
        private List<String> fields = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder typeKey(String typeKey) {
            this.typeKey = typeKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTypeRequest o) {
            this.registryId(o.getRegistryId());
            this.typeKey(o.getTypeKey());
            this.opcRequestId(o.getOpcRequestId());
            this.fields(o.getFields());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTypeRequest build() {
            GetTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTypeRequest buildWithoutInvocationCallback() {
            GetTypeRequest request = new GetTypeRequest();
            request.registryId = this.registryId;
            request.typeKey = this.typeKey;
            request.opcRequestId = this.opcRequestId;
            request.fields = this.fields;
            return request;
        }
    }
}

