/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOperationRequest
extends BmcRequest<Void> {
    private String registryId;
    private String connectionKey;
    private String schemaResourceName;
    private String operationResourceName;
    private String opcRequestId;
    private String endpointId;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getOperationResourceName() {
        return this.operationResourceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).connectionKey(this.connectionKey).schemaResourceName(this.schemaResourceName).operationResourceName(this.operationResourceName).opcRequestId(this.opcRequestId).endpointId(this.endpointId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",schemaResourceName=").append(String.valueOf(this.schemaResourceName));
        sb.append(",operationResourceName=").append(String.valueOf(this.operationResourceName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",endpointId=").append(String.valueOf(this.endpointId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOperationRequest)) {
            return false;
        }
        GetOperationRequest other = (GetOperationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.schemaResourceName, other.schemaResourceName) && Objects.equals(this.operationResourceName, other.operationResourceName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.endpointId, other.endpointId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.schemaResourceName == null ? 43 : this.schemaResourceName.hashCode());
        result = result * 59 + (this.operationResourceName == null ? 43 : this.operationResourceName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOperationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String connectionKey = null;
        private String schemaResourceName = null;
        private String operationResourceName = null;
        private String opcRequestId = null;
        private String endpointId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder operationResourceName(String operationResourceName) {
            this.operationResourceName = operationResourceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOperationRequest o) {
            this.registryId(o.getRegistryId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.operationResourceName(o.getOperationResourceName());
            this.opcRequestId(o.getOpcRequestId());
            this.endpointId(o.getEndpointId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOperationRequest build() {
            GetOperationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOperationRequest buildWithoutInvocationCallback() {
            GetOperationRequest request = new GetOperationRequest();
            request.registryId = this.registryId;
            request.connectionKey = this.connectionKey;
            request.schemaResourceName = this.schemaResourceName;
            request.operationResourceName = this.operationResourceName;
            request.opcRequestId = this.opcRequestId;
            request.endpointId = this.endpointId;
            return request;
        }
    }
}

