/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExecuteOperationJobRequest
extends BmcRequest<Void> {
    private String registryId;
    private String connectionKey;
    private String schemaResourceName;
    private String executeOperationJobKey;
    private String opcRequestId;
    private String endpointId;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getExecuteOperationJobKey() {
        return this.executeOperationJobKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).connectionKey(this.connectionKey).schemaResourceName(this.schemaResourceName).executeOperationJobKey(this.executeOperationJobKey).opcRequestId(this.opcRequestId).endpointId(this.endpointId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",schemaResourceName=").append(String.valueOf(this.schemaResourceName));
        sb.append(",executeOperationJobKey=").append(String.valueOf(this.executeOperationJobKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",endpointId=").append(String.valueOf(this.endpointId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExecuteOperationJobRequest)) {
            return false;
        }
        GetExecuteOperationJobRequest other = (GetExecuteOperationJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.schemaResourceName, other.schemaResourceName) && Objects.equals(this.executeOperationJobKey, other.executeOperationJobKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.endpointId, other.endpointId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.schemaResourceName == null ? 43 : this.schemaResourceName.hashCode());
        result = result * 59 + (this.executeOperationJobKey == null ? 43 : this.executeOperationJobKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExecuteOperationJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String connectionKey = null;
        private String schemaResourceName = null;
        private String executeOperationJobKey = null;
        private String opcRequestId = null;
        private String endpointId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder executeOperationJobKey(String executeOperationJobKey) {
            this.executeOperationJobKey = executeOperationJobKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExecuteOperationJobRequest o) {
            this.registryId(o.getRegistryId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.executeOperationJobKey(o.getExecuteOperationJobKey());
            this.opcRequestId(o.getOpcRequestId());
            this.endpointId(o.getEndpointId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExecuteOperationJobRequest build() {
            GetExecuteOperationJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExecuteOperationJobRequest buildWithoutInvocationCallback() {
            GetExecuteOperationJobRequest request = new GetExecuteOperationJobRequest();
            request.registryId = this.registryId;
            request.connectionKey = this.connectionKey;
            request.schemaResourceName = this.schemaResourceName;
            request.executeOperationJobKey = this.executeOperationJobKey;
            request.opcRequestId = this.opcRequestId;
            request.endpointId = this.endpointId;
            return request;
        }
    }
}

