/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConnectionRequest
extends BmcRequest<Void> {
    private String registryId;
    private String connectionKey;
    private String opcRequestId;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).connectionKey(this.connectionKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConnectionRequest)) {
            return false;
        }
        GetConnectionRequest other = (GetConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String connectionKey = null;
        private String opcRequestId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectionRequest o) {
            this.registryId(o.getRegistryId());
            this.connectionKey(o.getConnectionKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectionRequest build() {
            GetConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConnectionRequest buildWithoutInvocationCallback() {
            GetConnectionRequest request = new GetConnectionRequest();
            request.registryId = this.registryId;
            request.connectionKey = this.connectionKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

