/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.DeriveEntitiesDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeriveEntitiesRequest
extends BmcRequest<DeriveEntitiesDetails> {
    private String registryId;
    private DeriveEntitiesDetails deriveEntitiesDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getRegistryId() {
        return this.registryId;
    }

    public DeriveEntitiesDetails getDeriveEntitiesDetails() {
        return this.deriveEntitiesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public DeriveEntitiesDetails getBody$() {
        return this.deriveEntitiesDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).deriveEntitiesDetails(this.deriveEntitiesDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",deriveEntitiesDetails=").append(String.valueOf((Object)this.deriveEntitiesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeriveEntitiesRequest)) {
            return false;
        }
        DeriveEntitiesRequest other = (DeriveEntitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals((Object)this.deriveEntitiesDetails, (Object)other.deriveEntitiesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.deriveEntitiesDetails == null ? 43 : this.deriveEntitiesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeriveEntitiesRequest, DeriveEntitiesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private DeriveEntitiesDetails deriveEntitiesDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder deriveEntitiesDetails(DeriveEntitiesDetails deriveEntitiesDetails) {
            this.deriveEntitiesDetails = deriveEntitiesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeriveEntitiesRequest o) {
            this.registryId(o.getRegistryId());
            this.deriveEntitiesDetails(o.getDeriveEntitiesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeriveEntitiesRequest build() {
            DeriveEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DeriveEntitiesDetails body) {
            this.deriveEntitiesDetails(body);
            return this;
        }

        public DeriveEntitiesRequest buildWithoutInvocationCallback() {
            DeriveEntitiesRequest request = new DeriveEntitiesRequest();
            request.registryId = this.registryId;
            request.deriveEntitiesDetails = this.deriveEntitiesDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

