/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.CreateReferenceArtifactDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateReferenceArtifactRequest
extends BmcRequest<CreateReferenceArtifactDetails> {
    private String registryId;
    private String dcmsArtifactId;
    private CreateReferenceArtifactDetails createReferenceArtifactDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getDcmsArtifactId() {
        return this.dcmsArtifactId;
    }

    public CreateReferenceArtifactDetails getCreateReferenceArtifactDetails() {
        return this.createReferenceArtifactDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public CreateReferenceArtifactDetails getBody$() {
        return this.createReferenceArtifactDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).dcmsArtifactId(this.dcmsArtifactId).createReferenceArtifactDetails(this.createReferenceArtifactDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",dcmsArtifactId=").append(String.valueOf(this.dcmsArtifactId));
        sb.append(",createReferenceArtifactDetails=").append(String.valueOf((Object)this.createReferenceArtifactDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateReferenceArtifactRequest)) {
            return false;
        }
        CreateReferenceArtifactRequest other = (CreateReferenceArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.dcmsArtifactId, other.dcmsArtifactId) && Objects.equals((Object)this.createReferenceArtifactDetails, (Object)other.createReferenceArtifactDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.dcmsArtifactId == null ? 43 : this.dcmsArtifactId.hashCode());
        result = result * 59 + (this.createReferenceArtifactDetails == null ? 43 : this.createReferenceArtifactDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateReferenceArtifactRequest, CreateReferenceArtifactDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String dcmsArtifactId = null;
        private CreateReferenceArtifactDetails createReferenceArtifactDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder dcmsArtifactId(String dcmsArtifactId) {
            this.dcmsArtifactId = dcmsArtifactId;
            return this;
        }

        public Builder createReferenceArtifactDetails(CreateReferenceArtifactDetails createReferenceArtifactDetails) {
            this.createReferenceArtifactDetails = createReferenceArtifactDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateReferenceArtifactRequest o) {
            this.registryId(o.getRegistryId());
            this.dcmsArtifactId(o.getDcmsArtifactId());
            this.createReferenceArtifactDetails(o.getCreateReferenceArtifactDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateReferenceArtifactRequest build() {
            CreateReferenceArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateReferenceArtifactDetails body) {
            this.createReferenceArtifactDetails(body);
            return this;
        }

        public CreateReferenceArtifactRequest buildWithoutInvocationCallback() {
            CreateReferenceArtifactRequest request = new CreateReferenceArtifactRequest();
            request.registryId = this.registryId;
            request.dcmsArtifactId = this.dcmsArtifactId;
            request.createReferenceArtifactDetails = this.createReferenceArtifactDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

