/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.CreateConnectivityValidationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateConnectivityValidationRequest
extends BmcRequest<CreateConnectivityValidationDetails> {
    private String registryId;
    private CreateConnectivityValidationDetails createConnectivityValidationDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String endpointId;

    public String getRegistryId() {
        return this.registryId;
    }

    public CreateConnectivityValidationDetails getCreateConnectivityValidationDetails() {
        return this.createConnectivityValidationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    @InternalSdk
    public CreateConnectivityValidationDetails getBody$() {
        return this.createConnectivityValidationDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).createConnectivityValidationDetails(this.createConnectivityValidationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).endpointId(this.endpointId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",createConnectivityValidationDetails=").append(String.valueOf((Object)this.createConnectivityValidationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",endpointId=").append(String.valueOf(this.endpointId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConnectivityValidationRequest)) {
            return false;
        }
        CreateConnectivityValidationRequest other = (CreateConnectivityValidationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals((Object)this.createConnectivityValidationDetails, (Object)other.createConnectivityValidationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.endpointId, other.endpointId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.createConnectivityValidationDetails == null ? 43 : this.createConnectivityValidationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateConnectivityValidationRequest, CreateConnectivityValidationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private CreateConnectivityValidationDetails createConnectivityValidationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String endpointId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder createConnectivityValidationDetails(CreateConnectivityValidationDetails createConnectivityValidationDetails) {
            this.createConnectivityValidationDetails = createConnectivityValidationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateConnectivityValidationRequest o) {
            this.registryId(o.getRegistryId());
            this.createConnectivityValidationDetails(o.getCreateConnectivityValidationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.endpointId(o.getEndpointId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateConnectivityValidationRequest build() {
            CreateConnectivityValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateConnectivityValidationDetails body) {
            this.createConnectivityValidationDetails(body);
            return this;
        }

        public CreateConnectivityValidationRequest buildWithoutInvocationCallback() {
            CreateConnectivityValidationRequest request = new CreateConnectivityValidationRequest();
            request.registryId = this.registryId;
            request.createConnectivityValidationDetails = this.createConnectivityValidationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.endpointId = this.endpointId;
            return request;
        }
    }
}

