/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.ConfigValues;
import com.oracle.bmc.dataconnectivity.model.CreateConnectivityValidationDetails;
import com.oracle.bmc.dataconnectivity.model.DataEntity;
import com.oracle.bmc.dataconnectivity.model.InputPort;
import com.oracle.bmc.dataconnectivity.model.OutputPort;
import com.oracle.bmc.dataconnectivity.model.Parameter;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.SchemaDriftConfig;
import com.oracle.bmc.dataconnectivity.model.Shape;
import com.oracle.bmc.dataconnectivity.model.WriteOperationConfig;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Target
extends CreateConnectivityValidationDetails {
    @JsonProperty(value="entity")
    private final DataEntity entity;
    @JsonProperty(value="isReadAccess")
    private final Boolean isReadAccess;
    @JsonProperty(value="isCopyFields")
    private final Boolean isCopyFields;
    @JsonProperty(value="isPredefinedShape")
    private final Boolean isPredefinedShape;
    @JsonProperty(value="dataProperty")
    private final DataProperty dataProperty;
    @JsonProperty(value="schemaDriftConfig")
    private final SchemaDriftConfig schemaDriftConfig;
    @JsonProperty(value="fixedDataShape")
    private final Shape fixedDataShape;
    @JsonProperty(value="writeOperationConfig")
    private final WriteOperationConfig writeOperationConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Target(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<OutputPort> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, DataEntity entity, Boolean isReadAccess, Boolean isCopyFields, Boolean isPredefinedShape, DataProperty dataProperty, SchemaDriftConfig schemaDriftConfig, Shape fixedDataShape, WriteOperationConfig writeOperationConfig) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.entity = entity;
        this.isReadAccess = isReadAccess;
        this.isCopyFields = isCopyFields;
        this.isPredefinedShape = isPredefinedShape;
        this.dataProperty = dataProperty;
        this.schemaDriftConfig = schemaDriftConfig;
        this.fixedDataShape = fixedDataShape;
        this.writeOperationConfig = writeOperationConfig;
    }

    public DataEntity getEntity() {
        return this.entity;
    }

    public Boolean getIsReadAccess() {
        return this.isReadAccess;
    }

    public Boolean getIsCopyFields() {
        return this.isCopyFields;
    }

    public Boolean getIsPredefinedShape() {
        return this.isPredefinedShape;
    }

    public DataProperty getDataProperty() {
        return this.dataProperty;
    }

    public SchemaDriftConfig getSchemaDriftConfig() {
        return this.schemaDriftConfig;
    }

    public Shape getFixedDataShape() {
        return this.fixedDataShape;
    }

    public WriteOperationConfig getWriteOperationConfig() {
        return this.writeOperationConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Target(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", entity=").append(String.valueOf((Object)this.entity));
        sb.append(", isReadAccess=").append(String.valueOf(this.isReadAccess));
        sb.append(", isCopyFields=").append(String.valueOf(this.isCopyFields));
        sb.append(", isPredefinedShape=").append(String.valueOf(this.isPredefinedShape));
        sb.append(", dataProperty=").append(String.valueOf((Object)this.dataProperty));
        sb.append(", schemaDriftConfig=").append(String.valueOf((Object)this.schemaDriftConfig));
        sb.append(", fixedDataShape=").append(String.valueOf((Object)this.fixedDataShape));
        sb.append(", writeOperationConfig=").append(String.valueOf((Object)this.writeOperationConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Target)) {
            return false;
        }
        Target other = (Target)((Object)o);
        return Objects.equals((Object)this.entity, (Object)other.entity) && Objects.equals(this.isReadAccess, other.isReadAccess) && Objects.equals(this.isCopyFields, other.isCopyFields) && Objects.equals(this.isPredefinedShape, other.isPredefinedShape) && Objects.equals((Object)this.dataProperty, (Object)other.dataProperty) && Objects.equals((Object)this.schemaDriftConfig, (Object)other.schemaDriftConfig) && Objects.equals((Object)this.fixedDataShape, (Object)other.fixedDataShape) && Objects.equals((Object)this.writeOperationConfig, (Object)other.writeOperationConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.entity == null ? 43 : this.entity.hashCode());
        result = result * 59 + (this.isReadAccess == null ? 43 : this.isReadAccess.hashCode());
        result = result * 59 + (this.isCopyFields == null ? 43 : this.isCopyFields.hashCode());
        result = result * 59 + (this.isPredefinedShape == null ? 43 : this.isPredefinedShape.hashCode());
        result = result * 59 + (this.dataProperty == null ? 43 : this.dataProperty.hashCode());
        result = result * 59 + (this.schemaDriftConfig == null ? 43 : this.schemaDriftConfig.hashCode());
        result = result * 59 + (this.fixedDataShape == null ? 43 : this.fixedDataShape.hashCode());
        result = result * 59 + (this.writeOperationConfig == null ? 43 : this.writeOperationConfig.hashCode());
        return result;
    }

    public static enum DataProperty implements BmcEnum
    {
        Truncate("TRUNCATE"),
        Merge("MERGE"),
        Backup("BACKUP"),
        Overwrite("OVERWRITE"),
        Append("APPEND"),
        Ignore("IGNORE");

        private final String value;
        private static Map<String, DataProperty> map;

        private DataProperty(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataProperty create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DataProperty: " + key);
        }

        static {
            map = new HashMap<String, DataProperty>();
            for (DataProperty v : DataProperty.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<OutputPort> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="entity")
        private DataEntity entity;
        @JsonProperty(value="isReadAccess")
        private Boolean isReadAccess;
        @JsonProperty(value="isCopyFields")
        private Boolean isCopyFields;
        @JsonProperty(value="isPredefinedShape")
        private Boolean isPredefinedShape;
        @JsonProperty(value="dataProperty")
        private DataProperty dataProperty;
        @JsonProperty(value="schemaDriftConfig")
        private SchemaDriftConfig schemaDriftConfig;
        @JsonProperty(value="fixedDataShape")
        private Shape fixedDataShape;
        @JsonProperty(value="writeOperationConfig")
        private WriteOperationConfig writeOperationConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<OutputPort> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder entity(DataEntity entity) {
            this.entity = entity;
            this.__explicitlySet__.add("entity");
            return this;
        }

        public Builder isReadAccess(Boolean isReadAccess) {
            this.isReadAccess = isReadAccess;
            this.__explicitlySet__.add("isReadAccess");
            return this;
        }

        public Builder isCopyFields(Boolean isCopyFields) {
            this.isCopyFields = isCopyFields;
            this.__explicitlySet__.add("isCopyFields");
            return this;
        }

        public Builder isPredefinedShape(Boolean isPredefinedShape) {
            this.isPredefinedShape = isPredefinedShape;
            this.__explicitlySet__.add("isPredefinedShape");
            return this;
        }

        public Builder dataProperty(DataProperty dataProperty) {
            this.dataProperty = dataProperty;
            this.__explicitlySet__.add("dataProperty");
            return this;
        }

        public Builder schemaDriftConfig(SchemaDriftConfig schemaDriftConfig) {
            this.schemaDriftConfig = schemaDriftConfig;
            this.__explicitlySet__.add("schemaDriftConfig");
            return this;
        }

        public Builder fixedDataShape(Shape fixedDataShape) {
            this.fixedDataShape = fixedDataShape;
            this.__explicitlySet__.add("fixedDataShape");
            return this;
        }

        public Builder writeOperationConfig(WriteOperationConfig writeOperationConfig) {
            this.writeOperationConfig = writeOperationConfig;
            this.__explicitlySet__.add("writeOperationConfig");
            return this;
        }

        public Target build() {
            Target model = new Target(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.entity, this.isReadAccess, this.isCopyFields, this.isPredefinedShape, this.dataProperty, this.schemaDriftConfig, this.fixedDataShape, this.writeOperationConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Target model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("entity")) {
                this.entity(model.getEntity());
            }
            if (model.wasPropertyExplicitlySet("isReadAccess")) {
                this.isReadAccess(model.getIsReadAccess());
            }
            if (model.wasPropertyExplicitlySet("isCopyFields")) {
                this.isCopyFields(model.getIsCopyFields());
            }
            if (model.wasPropertyExplicitlySet("isPredefinedShape")) {
                this.isPredefinedShape(model.getIsPredefinedShape());
            }
            if (model.wasPropertyExplicitlySet("dataProperty")) {
                this.dataProperty(model.getDataProperty());
            }
            if (model.wasPropertyExplicitlySet("schemaDriftConfig")) {
                this.schemaDriftConfig(model.getSchemaDriftConfig());
            }
            if (model.wasPropertyExplicitlySet("fixedDataShape")) {
                this.fixedDataShape(model.getFixedDataShape());
            }
            if (model.wasPropertyExplicitlySet("writeOperationConfig")) {
                this.writeOperationConfig(model.getWriteOperationConfig());
            }
            return this;
        }
    }
}

