/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AttributeProfileResult;
import com.oracle.bmc.dataconnectivity.model.DataTypeStat;
import com.oracle.bmc.dataconnectivity.model.ObjectFreqStat;
import com.oracle.bmc.dataconnectivity.model.ProfileStat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class StringAttribute
extends AttributeProfileResult {
    @JsonProperty(value="minLength")
    private final ProfileStat minLength;
    @JsonProperty(value="maxLength")
    private final ProfileStat maxLength;
    @JsonProperty(value="meanLength")
    private final ProfileStat meanLength;
    @JsonProperty(value="patternFrequencies")
    private final List<ObjectFreqStat> patternFrequencies;
    @JsonProperty(value="inferredDataTypes")
    private final List<DataTypeStat> inferredDataTypes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StringAttribute(String name, ProfileStat min, ProfileStat max, ProfileStat nullCount, ProfileStat distinctCount, ProfileStat uniqueCount, ProfileStat duplicateCount, List<ObjectFreqStat> valueFrequencies, ProfileStat minLength, ProfileStat maxLength, ProfileStat meanLength, List<ObjectFreqStat> patternFrequencies, List<DataTypeStat> inferredDataTypes) {
        super(name, min, max, nullCount, distinctCount, uniqueCount, duplicateCount, valueFrequencies);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.meanLength = meanLength;
        this.patternFrequencies = patternFrequencies;
        this.inferredDataTypes = inferredDataTypes;
    }

    public ProfileStat getMinLength() {
        return this.minLength;
    }

    public ProfileStat getMaxLength() {
        return this.maxLength;
    }

    public ProfileStat getMeanLength() {
        return this.meanLength;
    }

    public List<ObjectFreqStat> getPatternFrequencies() {
        return this.patternFrequencies;
    }

    public List<DataTypeStat> getInferredDataTypes() {
        return this.inferredDataTypes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StringAttribute(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", minLength=").append(String.valueOf((Object)this.minLength));
        sb.append(", maxLength=").append(String.valueOf((Object)this.maxLength));
        sb.append(", meanLength=").append(String.valueOf((Object)this.meanLength));
        sb.append(", patternFrequencies=").append(String.valueOf(this.patternFrequencies));
        sb.append(", inferredDataTypes=").append(String.valueOf(this.inferredDataTypes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringAttribute)) {
            return false;
        }
        StringAttribute other = (StringAttribute)((Object)o);
        return Objects.equals((Object)this.minLength, (Object)other.minLength) && Objects.equals((Object)this.maxLength, (Object)other.maxLength) && Objects.equals((Object)this.meanLength, (Object)other.meanLength) && Objects.equals(this.patternFrequencies, other.patternFrequencies) && Objects.equals(this.inferredDataTypes, other.inferredDataTypes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.minLength == null ? 43 : this.minLength.hashCode());
        result = result * 59 + (this.maxLength == null ? 43 : this.maxLength.hashCode());
        result = result * 59 + (this.meanLength == null ? 43 : this.meanLength.hashCode());
        result = result * 59 + (this.patternFrequencies == null ? 43 : this.patternFrequencies.hashCode());
        result = result * 59 + (this.inferredDataTypes == null ? 43 : this.inferredDataTypes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="min")
        private ProfileStat min;
        @JsonProperty(value="max")
        private ProfileStat max;
        @JsonProperty(value="nullCount")
        private ProfileStat nullCount;
        @JsonProperty(value="distinctCount")
        private ProfileStat distinctCount;
        @JsonProperty(value="uniqueCount")
        private ProfileStat uniqueCount;
        @JsonProperty(value="duplicateCount")
        private ProfileStat duplicateCount;
        @JsonProperty(value="valueFrequencies")
        private List<ObjectFreqStat> valueFrequencies;
        @JsonProperty(value="minLength")
        private ProfileStat minLength;
        @JsonProperty(value="maxLength")
        private ProfileStat maxLength;
        @JsonProperty(value="meanLength")
        private ProfileStat meanLength;
        @JsonProperty(value="patternFrequencies")
        private List<ObjectFreqStat> patternFrequencies;
        @JsonProperty(value="inferredDataTypes")
        private List<DataTypeStat> inferredDataTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder min(ProfileStat min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder max(ProfileStat max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public Builder nullCount(ProfileStat nullCount) {
            this.nullCount = nullCount;
            this.__explicitlySet__.add("nullCount");
            return this;
        }

        public Builder distinctCount(ProfileStat distinctCount) {
            this.distinctCount = distinctCount;
            this.__explicitlySet__.add("distinctCount");
            return this;
        }

        public Builder uniqueCount(ProfileStat uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.__explicitlySet__.add("uniqueCount");
            return this;
        }

        public Builder duplicateCount(ProfileStat duplicateCount) {
            this.duplicateCount = duplicateCount;
            this.__explicitlySet__.add("duplicateCount");
            return this;
        }

        public Builder valueFrequencies(List<ObjectFreqStat> valueFrequencies) {
            this.valueFrequencies = valueFrequencies;
            this.__explicitlySet__.add("valueFrequencies");
            return this;
        }

        public Builder minLength(ProfileStat minLength) {
            this.minLength = minLength;
            this.__explicitlySet__.add("minLength");
            return this;
        }

        public Builder maxLength(ProfileStat maxLength) {
            this.maxLength = maxLength;
            this.__explicitlySet__.add("maxLength");
            return this;
        }

        public Builder meanLength(ProfileStat meanLength) {
            this.meanLength = meanLength;
            this.__explicitlySet__.add("meanLength");
            return this;
        }

        public Builder patternFrequencies(List<ObjectFreqStat> patternFrequencies) {
            this.patternFrequencies = patternFrequencies;
            this.__explicitlySet__.add("patternFrequencies");
            return this;
        }

        public Builder inferredDataTypes(List<DataTypeStat> inferredDataTypes) {
            this.inferredDataTypes = inferredDataTypes;
            this.__explicitlySet__.add("inferredDataTypes");
            return this;
        }

        public StringAttribute build() {
            StringAttribute model = new StringAttribute(this.name, this.min, this.max, this.nullCount, this.distinctCount, this.uniqueCount, this.duplicateCount, this.valueFrequencies, this.minLength, this.maxLength, this.meanLength, this.patternFrequencies, this.inferredDataTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StringAttribute model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            if (model.wasPropertyExplicitlySet("nullCount")) {
                this.nullCount(model.getNullCount());
            }
            if (model.wasPropertyExplicitlySet("distinctCount")) {
                this.distinctCount(model.getDistinctCount());
            }
            if (model.wasPropertyExplicitlySet("uniqueCount")) {
                this.uniqueCount(model.getUniqueCount());
            }
            if (model.wasPropertyExplicitlySet("duplicateCount")) {
                this.duplicateCount(model.getDuplicateCount());
            }
            if (model.wasPropertyExplicitlySet("valueFrequencies")) {
                this.valueFrequencies(model.getValueFrequencies());
            }
            if (model.wasPropertyExplicitlySet("minLength")) {
                this.minLength(model.getMinLength());
            }
            if (model.wasPropertyExplicitlySet("maxLength")) {
                this.maxLength(model.getMaxLength());
            }
            if (model.wasPropertyExplicitlySet("meanLength")) {
                this.meanLength(model.getMeanLength());
            }
            if (model.wasPropertyExplicitlySet("patternFrequencies")) {
                this.patternFrequencies(model.getPatternFrequencies());
            }
            if (model.wasPropertyExplicitlySet("inferredDataTypes")) {
                this.inferredDataTypes(model.getInferredDataTypes());
            }
            return this;
        }
    }
}

