/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.ObjectMetadata;
import com.oracle.bmc.dataconnectivity.model.OperationSummary;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class OperationSummaryFromProcedure
extends OperationSummary {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OperationSummaryFromProcedure(ObjectMetadata metadata, String key, String modelVersion, ParentReference parentRef, String name, Integer objectVersion, String externalKey, String resourceName, Integer objectStatus) {
        super(metadata);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.objectVersion = objectVersion;
        this.externalKey = externalKey;
        this.resourceName = resourceName;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OperationSummaryFromProcedure(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperationSummaryFromProcedure)) {
            return false;
        }
        OperationSummaryFromProcedure other = (OperationSummaryFromProcedure)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public OperationSummaryFromProcedure build() {
            OperationSummaryFromProcedure model = new OperationSummaryFromProcedure(this.metadata, this.key, this.modelVersion, this.parentRef, this.name, this.objectVersion, this.externalKey, this.resourceName, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OperationSummaryFromProcedure model) {
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

