/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkConnectivityStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataAssetKey")
    private final String dataAssetKey;
    @JsonProperty(value="privateEndPointKey")
    private final String privateEndPointKey;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="timeLastUpdated")
    private final Date timeLastUpdated;
    @JsonProperty(value="networkValidationStatusEnum")
    private final NetworkValidationStatusEnum networkValidationStatusEnum;

    @Deprecated
    @ConstructorProperties(value={"dataAssetKey", "privateEndPointKey", "errorMessage", "timeLastUpdated", "networkValidationStatusEnum"})
    public NetworkConnectivityStatus(String dataAssetKey, String privateEndPointKey, String errorMessage, Date timeLastUpdated, NetworkValidationStatusEnum networkValidationStatusEnum) {
        this.dataAssetKey = dataAssetKey;
        this.privateEndPointKey = privateEndPointKey;
        this.errorMessage = errorMessage;
        this.timeLastUpdated = timeLastUpdated;
        this.networkValidationStatusEnum = networkValidationStatusEnum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getPrivateEndPointKey() {
        return this.privateEndPointKey;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Date getTimeLastUpdated() {
        return this.timeLastUpdated;
    }

    public NetworkValidationStatusEnum getNetworkValidationStatusEnum() {
        return this.networkValidationStatusEnum;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkConnectivityStatus(");
        sb.append("super=").append(super.toString());
        sb.append("dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(", privateEndPointKey=").append(String.valueOf(this.privateEndPointKey));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", timeLastUpdated=").append(String.valueOf(this.timeLastUpdated));
        sb.append(", networkValidationStatusEnum=").append(String.valueOf((Object)this.networkValidationStatusEnum));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkConnectivityStatus)) {
            return false;
        }
        NetworkConnectivityStatus other = (NetworkConnectivityStatus)((Object)o);
        return Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.privateEndPointKey, other.privateEndPointKey) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.timeLastUpdated, other.timeLastUpdated) && Objects.equals((Object)this.networkValidationStatusEnum, (Object)other.networkValidationStatusEnum) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.privateEndPointKey == null ? 43 : this.privateEndPointKey.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.timeLastUpdated == null ? 43 : this.timeLastUpdated.hashCode());
        result = result * 59 + (this.networkValidationStatusEnum == null ? 43 : this.networkValidationStatusEnum.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NetworkValidationStatusEnum implements BmcEnum
    {
        Reachable("REACHABLE"),
        NotReachable("NOT_REACHABLE"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkValidationStatusEnum> map;

        private NetworkValidationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkValidationStatusEnum create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkValidationStatusEnum', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkValidationStatusEnum.class);
            map = new HashMap<String, NetworkValidationStatusEnum>();
            for (NetworkValidationStatusEnum v : NetworkValidationStatusEnum.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataAssetKey")
        private String dataAssetKey;
        @JsonProperty(value="privateEndPointKey")
        private String privateEndPointKey;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="timeLastUpdated")
        private Date timeLastUpdated;
        @JsonProperty(value="networkValidationStatusEnum")
        private NetworkValidationStatusEnum networkValidationStatusEnum;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            this.__explicitlySet__.add("dataAssetKey");
            return this;
        }

        public Builder privateEndPointKey(String privateEndPointKey) {
            this.privateEndPointKey = privateEndPointKey;
            this.__explicitlySet__.add("privateEndPointKey");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder timeLastUpdated(Date timeLastUpdated) {
            this.timeLastUpdated = timeLastUpdated;
            this.__explicitlySet__.add("timeLastUpdated");
            return this;
        }

        public Builder networkValidationStatusEnum(NetworkValidationStatusEnum networkValidationStatusEnum) {
            this.networkValidationStatusEnum = networkValidationStatusEnum;
            this.__explicitlySet__.add("networkValidationStatusEnum");
            return this;
        }

        public NetworkConnectivityStatus build() {
            NetworkConnectivityStatus model = new NetworkConnectivityStatus(this.dataAssetKey, this.privateEndPointKey, this.errorMessage, this.timeLastUpdated, this.networkValidationStatusEnum);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkConnectivityStatus model) {
            if (model.wasPropertyExplicitlySet("dataAssetKey")) {
                this.dataAssetKey(model.getDataAssetKey());
            }
            if (model.wasPropertyExplicitlySet("privateEndPointKey")) {
                this.privateEndPointKey(model.getPrivateEndPointKey());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("timeLastUpdated")) {
                this.timeLastUpdated(model.getTimeLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("networkValidationStatusEnum")) {
                this.networkValidationStatusEnum(model.getNetworkValidationStatusEnum());
            }
            return this;
        }
    }
}

