/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.PushDownOperation;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Join
extends PushDownOperation {
    @JsonProperty(value="condition")
    private final String condition;
    @JsonProperty(value="policy")
    private final Policy policy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Join(String condition, Policy policy) {
        this.condition = condition;
        this.policy = policy;
    }

    public String getCondition() {
        return this.condition;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Join(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", condition=").append(String.valueOf(this.condition));
        sb.append(", policy=").append(String.valueOf((Object)this.policy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)((Object)o);
        return Objects.equals(this.condition, other.condition) && Objects.equals((Object)this.policy, (Object)other.policy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.policy == null ? 43 : this.policy.hashCode());
        return result;
    }

    public static enum Policy implements BmcEnum
    {
        InnerJoin("INNER_JOIN"),
        LeftJoin("LEFT_JOIN"),
        RightJoin("RIGHT_JOIN"),
        FullJoin("FULL_JOIN");

        private final String value;
        private static Map<String, Policy> map;

        private Policy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Policy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Policy: " + key);
        }

        static {
            map = new HashMap<String, Policy>();
            for (Policy v : Policy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="condition")
        private String condition;
        @JsonProperty(value="policy")
        private Policy policy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder condition(String condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Join build() {
            Join model = new Join(this.condition, this.policy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Join model) {
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("policy")) {
                this.policy(model.getPolicy());
            }
            return this;
        }
    }
}

