/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.ReferencedDataObject;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeriveEntitiesItem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="mode")
    private final Mode mode;
    @JsonProperty(value="referencedDataObject")
    private final ReferencedDataObject referencedDataObject;

    @Deprecated
    @ConstructorProperties(value={"modelType", "mode", "referencedDataObject"})
    public DeriveEntitiesItem(String modelType, Mode mode, ReferencedDataObject referencedDataObject) {
        this.modelType = modelType;
        this.mode = mode;
        this.referencedDataObject = referencedDataObject;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelType() {
        return this.modelType;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ReferencedDataObject getReferencedDataObject() {
        return this.referencedDataObject;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeriveEntitiesItem(");
        sb.append("super=").append(super.toString());
        sb.append("modelType=").append(String.valueOf(this.modelType));
        sb.append(", mode=").append(String.valueOf((Object)this.mode));
        sb.append(", referencedDataObject=").append(String.valueOf((Object)this.referencedDataObject));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeriveEntitiesItem)) {
            return false;
        }
        DeriveEntitiesItem other = (DeriveEntitiesItem)((Object)o);
        return Objects.equals(this.modelType, other.modelType) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals((Object)this.referencedDataObject, (Object)other.referencedDataObject) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + (this.referencedDataObject == null ? 43 : this.referencedDataObject.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Mode implements BmcEnum
    {
        In("IN"),
        Out("OUT");

        private final String value;
        private static Map<String, Mode> map;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Mode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Mode: " + key);
        }

        static {
            map = new HashMap<String, Mode>();
            for (Mode v : Mode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="mode")
        private Mode mode;
        @JsonProperty(value="referencedDataObject")
        private ReferencedDataObject referencedDataObject;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder referencedDataObject(ReferencedDataObject referencedDataObject) {
            this.referencedDataObject = referencedDataObject;
            this.__explicitlySet__.add("referencedDataObject");
            return this;
        }

        public DeriveEntitiesItem build() {
            DeriveEntitiesItem model = new DeriveEntitiesItem(this.modelType, this.mode, this.referencedDataObject);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeriveEntitiesItem model) {
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("referencedDataObject")) {
                this.referencedDataObject(model.getReferencedDataObject());
            }
            return this;
        }
    }
}

