/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AttributeProfileResult;
import com.oracle.bmc.dataconnectivity.model.EntityProfileResult;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataProfile
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityProfileResult")
    private final EntityProfileResult entityProfileResult;
    @JsonProperty(value="attributeProfileResults")
    private final List<AttributeProfileResult> attributeProfileResults;

    @Deprecated
    @ConstructorProperties(value={"entityName", "entityProfileResult", "attributeProfileResults"})
    public DataProfile(String entityName, EntityProfileResult entityProfileResult, List<AttributeProfileResult> attributeProfileResults) {
        this.entityName = entityName;
        this.entityProfileResult = entityProfileResult;
        this.attributeProfileResults = attributeProfileResults;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public EntityProfileResult getEntityProfileResult() {
        return this.entityProfileResult;
    }

    public List<AttributeProfileResult> getAttributeProfileResults() {
        return this.attributeProfileResults;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataProfile(");
        sb.append("super=").append(super.toString());
        sb.append("entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityProfileResult=").append(String.valueOf((Object)this.entityProfileResult));
        sb.append(", attributeProfileResults=").append(String.valueOf(this.attributeProfileResults));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataProfile)) {
            return false;
        }
        DataProfile other = (DataProfile)((Object)o);
        return Objects.equals(this.entityName, other.entityName) && Objects.equals((Object)this.entityProfileResult, (Object)other.entityProfileResult) && Objects.equals(this.attributeProfileResults, other.attributeProfileResults) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityProfileResult == null ? 43 : this.entityProfileResult.hashCode());
        result = result * 59 + (this.attributeProfileResults == null ? 43 : this.attributeProfileResults.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityProfileResult")
        private EntityProfileResult entityProfileResult;
        @JsonProperty(value="attributeProfileResults")
        private List<AttributeProfileResult> attributeProfileResults;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityProfileResult(EntityProfileResult entityProfileResult) {
            this.entityProfileResult = entityProfileResult;
            this.__explicitlySet__.add("entityProfileResult");
            return this;
        }

        public Builder attributeProfileResults(List<AttributeProfileResult> attributeProfileResults) {
            this.attributeProfileResults = attributeProfileResults;
            this.__explicitlySet__.add("attributeProfileResults");
            return this;
        }

        public DataProfile build() {
            DataProfile model = new DataProfile(this.entityName, this.entityProfileResult, this.attributeProfileResults);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataProfile model) {
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityProfileResult")) {
                this.entityProfileResult(model.getEntityProfileResult());
            }
            if (model.wasPropertyExplicitlySet("attributeProfileResults")) {
                this.attributeProfileResults(model.getAttributeProfileResults());
            }
            return this;
        }
    }
}

